/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Random;

public class PartitionEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    private XTMetaData m_metaData;
    protected int m_numColumns;
    private long m_numTotal;
    private long m_curRowNum;
    private Random m_random;
    private long[] m_numToDraw;
    private long[] m_curNumDrawn;
    private double[] m_percentages;
    private boolean[] m_notFilled;
    private boolean[] m_useCopyData;
    public static String TRAIN_SIZE_ATTRIBUTE_TAG = "trainSize";
    public static String TEST_SIZE_ATTRIBUTE_TAG = "testSize";
    public static String VALID_SIZE_ATTRIBUTE_TAG = "validSize";

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        XTProps props = this.getNodeProperties();
        this.m_metaData = this.getInputMetaData(0);
        this.m_numTotal = this.m_metaData.getNumRows();
        this.m_numColumns = this.m_metaData.getNumColumns();
        this.m_useCopyData = new boolean[this.m_numColumns];
        for (int col = 0; col < this.m_numColumns; ++col) {
            this.m_useCopyData[col] = this.m_metaData.isStringColumn(col) || this.m_metaData.isBlobColumn(col);
        }
        this.m_curRowNum = 0L;
        this.m_random = this.getRandomGenerator();
        this.m_percentages = new double[3];
        this.m_numToDraw = new long[3];
        this.m_percentages[0] = Double.parseDouble(props.getValue(TRAIN_SIZE_ATTRIBUTE_TAG, "0.70"));
        this.m_percentages[1] = Double.parseDouble(props.getValue(TEST_SIZE_ATTRIBUTE_TAG, "0.20"));
        long train_extra = 0L;
        long test_extra = 0L;
        double train_dbl = this.m_percentages[0] * (double)this.m_numTotal;
        double test_dbl = this.m_percentages[1] * (double)this.m_numTotal;
        if (train_dbl - Math.floor(train_dbl) == 0.5) {
            train_extra = 1L;
        } else if (test_dbl - Math.floor(test_dbl) == 0.5) {
            test_extra = 1L;
        }
        this.m_numToDraw[0] = (long)(train_dbl + 0.49) + train_extra;
        this.m_numToDraw[1] = (long)(test_dbl + 0.49) + test_extra;
        this.m_numToDraw[2] = this.m_numTotal - (this.m_numToDraw[0] + this.m_numToDraw[1]);
        this.m_curNumDrawn = new long[3];
        this.m_curNumDrawn[0] = 0L;
        this.m_curNumDrawn[1] = 0L;
        this.m_curNumDrawn[2] = 0L;
        this.m_notFilled = new boolean[3];
    }

    public void execute(CNKProcJavaTransform proc) {
        int nrowBlock = proc.getChunkInputRows(0);
        boolean[][] keepRow = new boolean[nrowBlock][3];
        int[] numKept = new int[3];
        for (int i = 0; i < nrowBlock; ++i) {
            int val;
            double testEval = this.m_random.nextDouble() * (double)(this.m_numTotal - this.m_curRowNum);
            if (testEval < (double)(this.m_numToDraw[val = (int)(this.m_random.nextDouble() * 3.0)] - this.m_curNumDrawn[val])) {
                keepRow[i][val] = true;
                int n = val;
                this.m_curNumDrawn[n] = this.m_curNumDrawn[n] + 1L;
                int n2 = val;
                numKept[n2] = numKept[n2] + 1;
                ++this.m_curRowNum;
                continue;
            }
            --i;
        }
        double[] ibuf = null;
        double[] obuf = null;
        int[] outIndex = new int[3];
        for (int output = 0; output < 3; ++output) {
            for (int i = 0; i < this.m_numColumns; ++i) {
                if (!this.m_useCopyData[i]) {
                    ibuf = proc.getChunkInputColumnData(0, i);
                    obuf = proc.getChunkOutputColumnData(output, i);
                }
                outIndex[output] = 0;
                for (int j = 0; j < nrowBlock; ++j) {
                    int colNum = i;
                    int inRow = j;
                    if (!keepRow[j][output]) continue;
                    int outRow = outIndex[output];
                    if (this.m_useCopyData[i]) {
                        proc.copyColumnData(output, colNum, outRow, 0, colNum, inRow, 1);
                    } else {
                        obuf[outRow] = ibuf[inRow];
                    }
                    int n = output;
                    outIndex[n] = outIndex[n] + 1;
                }
                ibuf = null;
                obuf = null;
            }
        }
        keepRow = null;
        System.gc();
        proc.setChunkOutputReleaseRows(0, numKept[0]);
        proc.setChunkOutputReleaseRows(1, numKept[1]);
        proc.setChunkOutputReleaseRows(2, numKept[2]);
    }
}

