/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBackingFileBuf;
import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKMemoryBuf;
import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcCallback;
import com.insightful.cnkjava.CNKProcSplusTransform;
import com.insightful.gdevice.SCanvas;
import com.insightful.gdevice.XML;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.EngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerFrame;
import com.insightful.miner.MinerOutputHandler;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.graph.CanvasTabbedPane;
import com.insightful.miner.graph.GraphFrame;
import com.insightful.splus.SplusCanvasHandler;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.graph.GraphWindow;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;

public class SplusScriptEngineNode
extends EngineNode
implements CNKProcCallback {
    public static final String TEST_INPUT_REQUIREMENTS_CACHE_NAME = "reqs";
    public static final String TEST_PROPS_CACHE_NAME = "props";
    public static final String TEST_OUTPUT_META_DATA_CACHE_NAME = "outmd";
    public static final String TEXT_OUTPUT_CACHE_NAME = "textOutput";
    public static final String GRAPH_OUTPUT_CACHE_NAME = "graphOutput";
    public static final String FUNCTION_ATTRIBUTE_TAG = "function";
    public static final String TEXT_OUTPUT_ATTRIBUTE_TAG = "asciiTextOutput";
    public static final String GRAPH_OUTPUT_ATTRIBUTE_TAG = "spjGraphOutput";
    public static final String SHOW_RESULTS_DURING_RUN_TAG = "showOutputDuringRun";
    public static final boolean SHOW_RESULTS_DURING_RUN_DEFAULT = false;
    public static final String STORE_RESULTS_FOR_VIEW_TAG = "storeOutputForView";
    public static final boolean STORE_RESULTS_FOR_VIEW_DEFAULT = true;
    public static final String SHOW_PARAMETERS_TABLE_ATTRIBUTE_TAG = "showParametersTable";
    public static final boolean SHOW_PARAMETERS_TABLE_DEFAULT = false;
    public static final String INCLUDE_TEST_TAG = "includeTestPhase";
    public static final boolean INCLUDE_TEST_DEFAULT = true;
    public static final String ONE_BLOCK_ATTRIBUTE_TAG = "oneBlock";
    public static final boolean ONE_BLOCK_DEFAULT = true;
    public static final String DO_SAMPLE_ATTRIBUTE_TAG = "doSample";
    public static final boolean DO_SAMPLE_DEFAULT = false;
    public static final String DYNAMIC_OUTPUTS_ATTRIBUTE_TAG = "dynamicOutputs";
    public static final boolean DYNAMIC_OUTPUTS_DEFAULT = true;
    public static final String COPY_INPUT_COLUMNS_ATTRIBUTE_TAG = "copyInputCols";
    public static final boolean COPY_INPUT_COLUMNS_DEFAULT = false;
    public static final String NEW_COLUMNS_ATTRIBUTE_TAG = "newColumns";
    public static final boolean NEW_COLUMNS_DEFAULT = false;
    public static final String SAMPLE_SIZE_ATTRIBUTE_TAG = "sampleSize";
    public static final long SAMPLE_SIZE_DEFAULT = 10000L;
    public static final String SCRIPT_ARGUMENTS_ATTRIBUTE_TAG = "scriptArguments";
    public static final String SCRIPT_ARGUMENTS_EXPRESSION_ATTRIBUTE_TAG = "scriptArgumentsExpression";
    public static final String VAR_FRAME_NUM_TAG = "varFrameNum";
    public static final String BIGDATA_SCRIPT_TAG = "bigdataScript";
    private LocalCanvasHandler m_localCanvasHandler;
    private LocalOutputHandler m_localOutputHandler;
    private boolean m_showResultsDuringRun;
    private boolean m_storeResultsForView;
    private CNKProcSplusTransform m_modifyDynamicOutputsMetaDataProc = null;
    private static String m_alphaNumChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    public static BigdataScriptCache[] g_bigdataScriptInputs = null;
    public static BigdataScriptCache[] g_bigdataScriptOutputs = null;

    public boolean hasCNKProc() {
        return !this.hasDataCacheProc();
    }

    public boolean hasDataCacheProc() {
        return this.isSampleRequired() || this.isBigdataScript();
    }

    public CNKProc procCreate() throws Exception {
        if (!this.testOK()) {
            throw new Exception("can't execute script : error during test");
        }
        CNKProcSplusTransform proc = this.getInitTransformProc();
        proc.setCallback(this);
        this.m_modifyDynamicOutputsMetaDataProc = proc;
        return proc;
    }

    private CNKProcSplusTransform getInitTransformProc() throws Exception {
        CNKProcSplusTransform proc = this.getNetworkManager().createSplusProc();
        if (this.isBigdataScript()) {
            proc.setMangleColumnNames(false);
        }
        if (proc.getCreateOK()) {
            proc.setDefaultStringBytes(this.getWorksheetPropertiesManager().getDefaultStringSize());
            long estimatedMaxBufBytes = (long)this.getWorksheetPropertiesManager().getMaxMBPerBlock() * 1000000L;
            int maxDynamicBufBytes = -1;
            if (estimatedMaxBufBytes > 0L && estimatedMaxBufBytes <= Integer.MAX_VALUE) {
                maxDynamicBufBytes = (int)estimatedMaxBufBytes;
            }
            proc.setMaxDynamicBufBytes(maxDynamicBufBytes);
        }
        return proc;
    }

    public void doCallback(CNKProc proc) {
        if (proc == null || !(proc instanceof CNKProcSplusTransform)) {
            return;
        }
        CNKProcSplusTransform sproc = (CNKProcSplusTransform)proc;
        int info = sproc.getCallbackInfo();
        if (info == 0) {
            this.executeBefore(sproc);
        } else if (info == 1) {
            this.executeAfter(sproc);
        }
    }

    public void procSetProperties(CNKProc proc) {
        String transformFn = this.getTransformFunction();
        String tempVar = this.getTransformTempVariable();
        CNKProcSplusTransform xform = (CNKProcSplusTransform)proc;
        xform.setUseFlexibleTransform(true);
        xform.setTransform(transformFn);
        xform.setTransformTempVariable(tempVar);
        xform.setVarFrameNum(this.getNodeProperties().getInt(VAR_FRAME_NUM_TAG, 0));
        xform.setDynamicOutputs(this.getDynamicOutputs());
        this.setInputRoles(xform);
        this.setInputRequirementsFromTest(xform);
        for (int inputNum = 0; inputNum < this.getNumInputs(); ++inputNum) {
            if (xform.getInputNeedsMetaData(inputNum)) {
                this.setInputMetaData(xform, inputNum);
            }
            if (!xform.getInputNeedsLevelCounts(inputNum)) continue;
            this.setInputLevelCounts(xform, inputNum);
        }
        this.m_showResultsDuringRun = this.getNodeProperties().getBoolean(SHOW_RESULTS_DURING_RUN_TAG, false);
        this.m_storeResultsForView = this.getNodeProperties().getBoolean(STORE_RESULTS_FOR_VIEW_TAG, true);
        if (!MinerApp.isInteractive()) {
            this.m_showResultsDuringRun = false;
        }
    }

    public void procModifyDynamicOutputsMetaData(CNKProc proc, int outputNum, XTMetaData md) {
        if (md != null && this.m_modifyDynamicOutputsMetaDataProc != null) {
            this.setOutputMetaDataRoles(md, this.m_modifyDynamicOutputsMetaDataProc, outputNum);
        }
    }

    private void clearResultsCaches() {
        this.setNodeCache(TEXT_OUTPUT_CACHE_NAME, null);
        Object[] cacheNames = this.getNodeCacheNames().toArray();
        for (int i = 0; i < cacheNames.length; ++i) {
            if (!((String)cacheNames[i]).startsWith(GRAPH_OUTPUT_CACHE_NAME)) continue;
            this.setNodeCache((String)cacheNames[i], null);
        }
    }

    private String getTransformFunction() {
        String val = this.getTransformFunctionBody();
        return val;
    }

    public String getSafeTransformFunction(String body) {
        String fn = "function(IM,.restart.first=T) {\n  restart(.restart.first, skip.error.handler = T)\n  if (.restart.first) {\n    .restart.first <- F\n    fn <- function(IM) {\n" + body + "\n}" + "\n" + "    val <- fn(IM)" + "\n" + "    if (is(val,'missing')) val <- list()" + "\n" + "    val" + "\n" + "  } else {" + "\n" + "    err.msg <- paste('S-PLUS Error:', get.message(even.if.used = T))" + "\n" + "    err.msg <- substituteString('\\nUse traceback.*','',err.msg)" + "\n" + "    list(error=as.character(err.msg))" + "\n" + "  }" + "\n" + "}" + "\n";
        return fn;
    }

    public String getTransformFunctionBody() {
        int numInputs = this.getNumInputs();
        int numOutputs = this.getNumOutputs();
        XTProps props = this.getNodeProperties();
        String userExpr = props.getValue(FUNCTION_ATTRIBUTE_TAG);
        if (this.isBigdataScript()) {
            userExpr = "\nbd.internal.miner.execute.bigdata.script(IM=IM, num.inputs=" + numInputs + ", num.outputs=" + numOutputs + ", user.fn=function(IM) {\n" + userExpr + "\n}\n)\n";
        }
        String testStr = "";
        boolean scriptDoesTest = props.getBoolean(INCLUDE_TEST_TAG, true);
        if (!scriptDoesTest) {
            int i;
            boolean oneBlock = props.getBoolean(ONE_BLOCK_ATTRIBUTE_TAG, true);
            boolean dynamicOutputs = props.getBoolean(DYNAMIC_OUTPUTS_ATTRIBUTE_TAG, true);
            boolean copyInputCols = props.getBoolean(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, false);
            boolean newCols = props.getBoolean(NEW_COLUMNS_ATTRIBUTE_TAG, false);
            Vector newColNames = props.getSubProperties(NEW_COLUMNS_ATTRIBUTE_TAG);
            int numNewCols = newColNames.size();
            if (numNewCols == 0) {
                newCols = false;
            }
            if (!copyInputCols && !newCols) {
                dynamicOutputs = true;
            }
            String testStrStart = "if(IM$test) {return(list(";
            String testStrEnd = "))}\n";
            String testStrMid = "";
            if (oneBlock) {
                i = 0;
                while (i < numInputs) {
                    testStrMid = testStrMid + "in" + ++i + ".requirements='one.block', ";
                }
            }
            if (dynamicOutputs) {
                testStrMid = testStrMid + "dynamic.outputs=T, ";
            } else {
                if (this.isBigdataScript()) {
                    testStrMid = testStrMid + "dynamic.outputs=T, ";
                }
                if (copyInputCols && !newCols) {
                    i = 0;
                    while (i < numInputs) {
                        testStrMid = testStrMid + "out" + ++i + "= if (ncol(IM$in" + i + ") > 0) { IM$in" + i + "} else { NULL }, " + "out" + i + ".column.roles=IM$in" + i + ".column.roles";
                    }
                } else {
                    int i2;
                    String newColDataStr = "data.frame(";
                    String newColRolesStr = "c(";
                    String curName = "";
                    String curType = "";
                    String curRole = "";
                    for (i2 = 0; i2 < numNewCols; ++i2) {
                        curName = (String)newColNames.elementAt(i2);
                        curType = props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, curName, XTMetaData.TYPE_ATTRIBUTE_TAG}, XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
                        curRole = props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, curName, XTMetaData.ROLE_ATTRIBUTE_TAG}, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG);
                        newColDataStr = curType.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG) ? newColDataStr + "'" + curName + "'=rep(0, max(1, nrow(IM$in1))), " : (curType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG) ? newColDataStr + "'" + curName + "'=factor(rep('A', max(1, nrow(IM$in1)))), " : (curType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG) ? newColDataStr + "'" + curName + "'=timeDate(julian=rep(0, max(1, nrow(IM$in1)))), " : newColDataStr + "'" + curName + "'=rep('', max(1, nrow(IM$in1))), "));
                        newColRolesStr = newColRolesStr + "'" + curRole + "', ";
                    }
                    newColDataStr = newColDataStr + "stringsAsFactors=F)";
                    newColRolesStr = newColRolesStr + ")";
                    if (!copyInputCols && newCols) {
                        i2 = 0;
                        while (i2 < numInputs) {
                            testStrMid = testStrMid + "out" + ++i2 + "=" + newColDataStr + ", " + "out" + i2 + ".column.roles=" + newColRolesStr + ", ";
                        }
                    } else {
                        i2 = 0;
                        while (i2 < numInputs) {
                            testStrMid = testStrMid + "out" + ++i2 + "= if(ncol(IM$in" + i2 + ") > 0) { data.frame(IM$in" + i2 + "," + newColDataStr + ") } else { data.frame(" + newColDataStr + ") }, out" + i2 + ".column.roles=c(IM$in" + i2 + ".column.roles, " + newColRolesStr + "), ";
                        }
                    }
                }
            }
            testStr = testStrStart + testStrMid + testStrEnd;
        }
        String nodeInfoStr = "IM$id <- '" + this.getNodeID() + "'; IM$label <- '" + this.getNodeName() + "'\n";
        String argStr = "";
        String argExpression = props.getValue(SCRIPT_ARGUMENTS_EXPRESSION_ATTRIBUTE_TAG, null);
        if (argExpression != null && argExpression.length() > 0) {
            argStr = "IM$args <- " + argExpression + "\n";
        } else {
            Vector argNames = props.getSubProperties(SCRIPT_ARGUMENTS_ATTRIBUTE_TAG);
            if (argNames.size() > 0) {
                StringBuffer argStrBuf = new StringBuffer();
                Vector argValues = props.getSubPropertyValues(SCRIPT_ARGUMENTS_ATTRIBUTE_TAG);
                argStrBuf.append("IM$args <- c(");
                for (int i = 0; i < argNames.size(); ++i) {
                    argStrBuf.append("'");
                    argStrBuf.append(argNames.elementAt(i));
                    argStrBuf.append("' = '");
                    argStrBuf.append(argValues.elementAt(i));
                    argStrBuf.append("', ");
                }
                argStrBuf.append(")\n");
                argStr = argStrBuf.toString();
            }
        }
        String completeBody = testStr + nodeInfoStr + argStr + this.getInitDeviceString() + userExpr;
        String fn = this.getSafeTransformFunction(completeBody);
        return fn;
    }

    public String getInitDeviceString() {
        return "if (!IM$test && !is.null(IM$in1.pos) && IM$in1.pos==1) dev.set(1)\n";
    }

    public static void setMetaDataFromBuf(XTMetaData md, CNKBuf buf) {
        int numColumns = buf.getNumColumns();
        for (int i = 0; i < numColumns; ++i) {
            String colName = buf.getColumnName(i);
            String colType = buf.getColumnType(i);
            if (colType.equals("factor")) {
                md.appendCategoricalDataField(colName, new String[0]);
                continue;
            }
            if (colType.equals("string")) {
                int stringWidth = buf.getColumnStringBytes(i);
                md.appendStringDataField(colName, stringWidth);
                continue;
            }
            if (colType.equals("blob")) {
                String blobClassName = buf.getColumnBlobClassName(i);
                md.appendBlobDataField(colName, blobClassName);
                continue;
            }
            if (colType.equals("timeDate")) {
                md.appendDateTimeDataField(colName);
                continue;
            }
            md.appendContinousDataField(colName);
        }
    }

    public String getTransformTempVariable() {
        return SplusScriptEngineNode.getTempSplusVar(this);
    }

    public static String getTempSplusVar(EngineNode node) {
        String nodeName = node.getNodeID() + "." + node.getNodeName();
        String newName = "";
        int nchars = nodeName.length();
        boolean lastIsDot = false;
        for (int i = 0; i < nchars; ++i) {
            char c = nodeName.charAt(i);
            if (m_alphaNumChars.indexOf(c) < 0) {
                if (!lastIsDot) {
                    newName = newName + ".";
                }
                lastIsDot = true;
                continue;
            }
            newName = newName + c;
            lastIsDot = false;
        }
        if (newName.endsWith(".")) {
            newName = newName.substring(0, newName.length() - 1);
        }
        if (newName.length() > 50) {
            newName = newName.substring(0, 50);
        }
        return newName;
    }

    private String getOutMDCacheName(int outputNum) {
        return TEST_OUTPUT_META_DATA_CACHE_NAME + Integer.toString(outputNum);
    }

    public void invalidateNodeState() {
        this.setNodeCache(TEST_PROPS_CACHE_NAME, null);
        this.setNodeCache(TEST_INPUT_REQUIREMENTS_CACHE_NAME, null);
        this.clearResultsCaches();
        for (int i = 0; i < this.getNumOutputs(); ++i) {
            this.setNodeCache(this.getOutMDCacheName(i), null);
        }
    }

    private boolean testOK() {
        this.updateTestInfo();
        return this.getNodeCache(TEST_INPUT_REQUIREMENTS_CACHE_NAME) != null;
    }

    private void updateTestInfo() {
        try {
            if (!this.getNetworkManager().isSplusLicensed() && !MinerApp.isInBDL()) {
                this.setNodeCache(TEST_PROPS_CACHE_NAME, null);
                return;
            }
            XTProps mdProps = this.getNodeCacheXTProps(TEST_PROPS_CACHE_NAME);
            XTProps currentProps = (XTProps)this.getNodeProperties().copy();
            currentProps.set("splus.script.node.inputs", this.getNumInputs());
            currentProps.set("splus.script.node.outputs", this.getNumOutputs());
            if (mdProps == null || !mdProps.equals(currentProps)) {
                int i;
                int i2;
                this.invalidateNodeState();
                for (int i3 = 0; i3 < this.getNumInputs(); ++i3) {
                    if (this.hasInputNode(i3)) continue;
                    this.printlnError(this.getNodeName() + ": unconnected input -- can't test script");
                    return;
                }
                String transformFn = this.getTransformFunction();
                String tempVar = this.getTransformTempVariable();
                CNKProcSplusTransform proc = this.getInitTransformProc();
                if (!proc.getCreateOK()) {
                    this.printlnError(this.getNodeName() + ": error testing function: " + proc.getCreateError());
                    this.setNodeCache(TEST_INPUT_REQUIREMENTS_CACHE_NAME, null);
                    this.setNodeCache(TEST_PROPS_CACHE_NAME, currentProps);
                    return;
                }
                proc.setNumRows(10);
                proc.setUseFlexibleTransform(true);
                proc.setTransform(transformFn);
                proc.setTransformTempVariable(tempVar);
                proc.setVarFrameNum(currentProps.getInt(VAR_FRAME_NUM_TAG, 0));
                this.setInputRoles(proc);
                Vector<CNKMemoryBuf> inbufs = new Vector<CNKMemoryBuf>();
                for (int i4 = 0; i4 < this.getNumInputs(); ++i4) {
                    CNKMemoryBuf buf = new CNKMemoryBuf();
                    buf.setNumRows(0);
                    XTMetaData inMD = this.getInputMetaData(i4);
                    int maxLevels = this.getWorksheetPropertiesManager().getMaxCategoricalLevels();
                    EngineNetworkManager.setBufColumnDescription(buf, inMD, maxLevels);
                    inbufs.add(buf);
                    proc.setInbuf(i4, buf);
                    buf.init();
                }
                Vector<CNKMemoryBuf> outbufs = new Vector<CNKMemoryBuf>();
                for (i2 = 0; i2 < this.getNumOutputs(); ++i2) {
                    CNKMemoryBuf buf = new CNKMemoryBuf();
                    buf.setNumRows(0);
                    buf.setNumColumns(0);
                    outbufs.add(buf);
                    proc.setOutbuf(i2, buf);
                    buf.init();
                }
                proc.init();
                proc.doTransformTest();
                for (i2 = 0; i2 < proc.getNumMessages(); ++i2) {
                    String msg = proc.getMessage(i2);
                    int severity = proc.getMessageSeverity(i2);
                    if (severity == 4) {
                        this.printlnError(this.getNodeName() + ": error testing function: " + msg);
                        continue;
                    }
                    this.printlnDebug(this.getNodeName() + ": msg testing function: " + msg);
                }
                boolean procHasErrors = proc.hasError();
                this.printlnDebug("splus script test -- " + (procHasErrors ? "errors" : "ok"));
                if (procHasErrors) {
                    this.setNodeCache(TEST_INPUT_REQUIREMENTS_CACHE_NAME, null);
                } else {
                    XTProps inputReqs = new XTProps();
                    for (int i5 = 0; i5 < this.getNumInputs(); ++i5) {
                        String[] path = new String[]{"input.requirements", Integer.toString(i5), "dummy"};
                        path[2] = "multi.pass";
                        inputReqs.set(path, proc.getInputNeedsMultiPass(i5));
                        path[2] = "random.access";
                        inputReqs.set(path, proc.getInputNeedsRandomAccess(i5));
                        path[2] = "total.rows";
                        inputReqs.set(path, proc.getInputNeedsTotalRows(i5));
                        path[2] = "factor.levels";
                        inputReqs.set(path, proc.getInputNeedsFactorLevels(i5));
                        path[2] = "meta.data";
                        inputReqs.set(path, proc.getInputNeedsMetaData(i5));
                        path[2] = "level.counts";
                        inputReqs.set(path, proc.getInputNeedsLevelCounts(i5));
                        path[2] = "one.block";
                        inputReqs.set(path, proc.getInputNeedsOneBlock(i5));
                    }
                    inputReqs.set("dynamic.outputs", proc.getDynamicOutputs());
                    this.setNodeCache(TEST_INPUT_REQUIREMENTS_CACHE_NAME, inputReqs);
                }
                for (i = 0; i < this.getNumOutputs(); ++i) {
                    CNKBuf outbuf = (CNKBuf)outbufs.get(i);
                    XTMetaData md = new XTMetaData();
                    if (!procHasErrors) {
                        SplusScriptEngineNode.setMetaDataFromBuf(md, outbuf);
                        this.setOutputMetaDataRoles(md, proc, i);
                    }
                    this.setNodeCache(this.getOutMDCacheName(i), md);
                }
                for (i = 0; i < inbufs.size(); ++i) {
                    CNKBuf buf = (CNKBuf)inbufs.get(i);
                    buf.destroyCNKObj();
                }
                for (i = 0; i < outbufs.size(); ++i) {
                    CNKBuf buf = (CNKBuf)outbufs.get(i);
                    buf.destroyCNKObj();
                }
                proc.destroyCNKObj();
                this.setNodeCache(TEST_PROPS_CACHE_NAME, currentProps);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setNodeCache(TEST_PROPS_CACHE_NAME, null);
        }
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        this.updateTestInfo();
        if (this.getNodeCacheXTProps(TEST_PROPS_CACHE_NAME) == null) {
            try {
                return new XTMetaData();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        XTMetaData md = this.getNodeCacheXTMetaData(this.getOutMDCacheName(outputNum));
        return md;
    }

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        this.updateTestInfo();
        if (this.getNodeCacheXTProps(TEST_PROPS_CACHE_NAME) == null) {
            return EngineNode.InputRequirements.getDefaultRequirements();
        }
        XTProps inputReqs = this.getNodeCacheXTProps(TEST_INPUT_REQUIREMENTS_CACHE_NAME);
        if (inputReqs == null) {
            return EngineNode.InputRequirements.getDefaultRequirements();
        }
        String[] path = new String[]{"input.requirements", Integer.toString(inputNum), "dummy"};
        path[2] = "multi.pass";
        boolean needsMultiPass = inputReqs.getBoolean(path, true);
        path[2] = "random.access";
        boolean needsRandomAccess = inputReqs.getBoolean(path, true);
        path[2] = "total.rows";
        boolean needsTotalRows = inputReqs.getBoolean(path, true);
        path[2] = "factor.levels";
        boolean needsFactorLevels = inputReqs.getBoolean(path, true);
        path[2] = "meta.data";
        boolean needsMetaData = inputReqs.getBoolean(path, true);
        path[2] = "level.counts";
        boolean needsLevelCounts = inputReqs.getBoolean(path, true);
        path[2] = "one.block";
        boolean needsOneBlock = inputReqs.getBoolean(path, false);
        return new EngineNode.InputRequirements(needsMultiPass, needsRandomAccess || needsOneBlock, needsFactorLevels, needsTotalRows, needsMetaData || needsLevelCounts, false);
    }

    public boolean hasDynamicOutputs() {
        return this.getDynamicOutputs();
    }

    private boolean getDynamicOutputs() {
        this.updateTestInfo();
        XTProps inputReqs = this.getNodeCacheXTProps(TEST_INPUT_REQUIREMENTS_CACHE_NAME);
        if (inputReqs == null) {
            return false;
        }
        return inputReqs.getBoolean("dynamic.outputs", false);
    }

    private void setOutputMetaDataRoles(XTMetaData md, CNKProcSplusTransform proc, int outputNum) {
        XTMetaData inputMD = this.getNumInputs() < 1 ? null : this.getInputMetaData(0);
        int numColumns = md.getNumColumns();
        int numProcRoles = proc.getOutputColumnRoleCount(outputNum);
        for (int colNum = 0; colNum < numColumns; ++colNum) {
            int matchingInputColumn;
            String outputRole = XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG;
            if (colNum < numProcRoles) {
                String userRole = proc.getOutputColumnRole(outputNum, colNum);
                if (userRole != null && (userRole.equals(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG) || userRole.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) || userRole.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG) || userRole.equals(XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG))) {
                    outputRole = userRole;
                }
            } else if (inputMD != null && (matchingInputColumn = inputMD.nameToOrdinal(md.ordinalToName(colNum))) >= 0) {
                outputRole = inputMD.getColumnRole(matchingInputColumn);
            }
            md.setDataFieldRole(colNum, outputRole);
        }
    }

    private void setInputRoles(CNKProcSplusTransform proc) {
        for (int inputNum = 0; inputNum < this.getNumInputs(); ++inputNum) {
            XTMetaData md = this.getInputMetaData(inputNum);
            Vector roles = md.getColumnRoles();
            for (int i = roles.size() - 1; i >= 0; --i) {
                String role = (String)roles.get(i);
                proc.setInputColumnRole(inputNum, i, role);
            }
        }
    }

    private void setInputRequirementsFromTest(CNKProcSplusTransform proc) {
        this.updateTestInfo();
        XTProps inputReqs = this.getNodeCacheXTProps(TEST_INPUT_REQUIREMENTS_CACHE_NAME);
        if (inputReqs == null) {
            return;
        }
        for (int inputNum = 0; inputNum < this.getNumInputs(); ++inputNum) {
            String[] path = new String[]{"input.requirements", Integer.toString(inputNum), "dummy"};
            path[2] = "multi.pass";
            boolean needsMultiPass = inputReqs.getBoolean(path, true);
            path[2] = "random.access";
            boolean needsRandomAccess = inputReqs.getBoolean(path, true);
            path[2] = "total.rows";
            boolean needsTotalRows = inputReqs.getBoolean(path, true);
            path[2] = "factor.levels";
            boolean needsFactorLevels = inputReqs.getBoolean(path, true);
            path[2] = "meta.data";
            boolean needsMetaData = inputReqs.getBoolean(path, true);
            path[2] = "level.counts";
            boolean needsLevelCounts = inputReqs.getBoolean(path, true);
            path[2] = "one.block";
            boolean needsOneBlock = inputReqs.getBoolean(path, false);
            proc.setInputNeedsMultiPass(inputNum, needsMultiPass);
            proc.setInputNeedsRandomAccess(inputNum, needsRandomAccess);
            proc.setInputNeedsTotalRows(inputNum, needsTotalRows);
            proc.setInputNeedsFactorLevels(inputNum, needsFactorLevels);
            proc.setInputNeedsMetaData(inputNum, needsMetaData);
            proc.setInputNeedsLevelCounts(inputNum, needsLevelCounts);
            proc.setInputNeedsOneBlock(inputNum, needsOneBlock);
        }
    }

    private void setInputMetaData(CNKProcSplusTransform proc, int inputNum) {
        XTMetaData inputMD = this.getInputMetaData(inputNum);
        int numColumns = inputMD.getNumColumns();
        for (int colNum = numColumns - 1; colNum >= 0; --colNum) {
            proc.setInputColumnCountMissing(inputNum, colNum, (long)inputMD.getColumnMissingCount(colNum));
            proc.setInputColumnMin(inputNum, colNum, inputMD.getColumnMin(colNum));
            proc.setInputColumnMax(inputNum, colNum, inputMD.getColumnMax(colNum));
            proc.setInputColumnMean(inputNum, colNum, inputMD.getColumnMean(colNum));
            proc.setInputColumnStdev(inputNum, colNum, inputMD.getColumnStandardDeviation(colNum));
        }
    }

    private void setInputLevelCounts(CNKProcSplusTransform proc, int inputNum) {
        XTMetaData inputMD = this.getInputMetaData(inputNum);
        int numColumns = inputMD.getNumColumns();
        for (int colNum = numColumns - 1; colNum >= 0; --colNum) {
            if (!inputMD.isCategoricalColumn(colNum)) continue;
            proc.prepareInputColumnLevelCount(inputNum, colNum);
            String colName = inputMD.ordinalToName(colNum);
            Vector levelNames = inputMD.getCategoricalDataFieldLevels(colName);
            int numLevels = levelNames.size();
            for (int levelNum = numLevels - 1; levelNum >= 0; --levelNum) {
                String levelName = (String)levelNames.get(levelNum);
                long levelCount = 0L;
                String levelCountString = inputMD.getLevelCount(colName, levelName);
                try {
                    levelCount = Long.parseLong(levelCountString);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                proc.setInputColumnLevelCount(levelNum, levelCount);
            }
        }
    }

    public void executeBefore(CNKProcSplusTransform proc) {
        if (this.m_localOutputHandler == null) {
            this.m_localOutputHandler = new LocalOutputHandler(this.m_showResultsDuringRun, this.m_storeResultsForView);
        }
        if (this.m_localCanvasHandler == null) {
            this.m_localCanvasHandler = new LocalCanvasHandler(this.m_showResultsDuringRun, this.m_storeResultsForView);
        }
        this.m_localOutputHandler.useCustomHandler();
        this.m_localCanvasHandler.useCustomHandler();
    }

    public void executeAfter(CNKProcSplusTransform proc) {
        this.m_localOutputHandler.useDefaultHandler();
        this.m_localCanvasHandler.useDefaultHandler();
        if (proc.hasError()) {
            String outputText = this.m_localOutputHandler.getText();
            if (outputText != null) {
                this.printInformation(outputText);
            }
            this.m_localOutputHandler.cleanup();
            this.m_localCanvasHandler.cleanup();
            this.m_localOutputHandler = null;
            this.m_localCanvasHandler = null;
            this.clearResultsCaches();
        }
    }

    public boolean isSampleRequired() {
        XTProps props = this.getNodeProperties();
        boolean doSample = !props.getBoolean(INCLUDE_TEST_TAG, true) && props.getBoolean(ONE_BLOCK_ATTRIBUTE_TAG, true) && props.getBoolean(DO_SAMPLE_ATTRIBUTE_TAG, false);
        return doSample;
    }

    public long getSampleSize() {
        XTProps props = this.getNodeProperties();
        String str = props.getValue(SAMPLE_SIZE_ATTRIBUTE_TAG, Long.toString(10000L));
        long val = 10000L;
        try {
            val = Long.parseLong(str);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (val < 0L) {
            val = 0L;
        }
        return val;
    }

    public boolean isBigdataScript() {
        XTProps props = this.getNodeProperties();
        boolean val = props.getBoolean(BIGDATA_SCRIPT_TAG, false);
        return val;
    }

    public boolean executeDataCacheProc() throws Exception {
        if (!this.testOK()) {
            throw new Exception("can't execute script : error during test");
        }
        if (this.isBigdataScript()) {
            return this.executeBigdataScript();
        }
        return this.executeSamplingScript();
    }

    protected boolean isDataCacheProcOutputMetaDataComplete(int outputNum) {
        return true;
    }

    private boolean executeBigdataScript() throws Exception {
        int i;
        int numInputs = this.getNumInputs();
        int numOutputs = this.getNumOutputs();
        g_bigdataScriptInputs = new BigdataScriptCache[numInputs];
        for (i = 0; i < numInputs; ++i) {
            SplusScriptEngineNode.g_bigdataScriptInputs[i] = new BigdataScriptCache();
            SplusScriptEngineNode.g_bigdataScriptInputs[i].m_metaData = this.getInputMetaData(i);
            SplusScriptEngineNode.g_bigdataScriptInputs[i].m_dirName = this.getNetworkManager().getWorksheetDirPath();
            SplusScriptEngineNode.g_bigdataScriptInputs[i].m_dcfFilename = this.getNetworkManager().getInputDataCacheFileName(this.getNodeID(), i);
            SplusScriptEngineNode.g_bigdataScriptInputs[i].m_mdfFilename = this.getNetworkManager().getInputMetaDataFileName(this.getNodeID(), i);
            SplusScriptEngineNode.g_bigdataScriptInputs[i].m_dbfFilename = this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), i);
        }
        g_bigdataScriptOutputs = new BigdataScriptCache[numOutputs];
        for (i = 0; i < numOutputs; ++i) {
            SplusScriptEngineNode.g_bigdataScriptOutputs[i] = new BigdataScriptCache();
            SplusScriptEngineNode.g_bigdataScriptOutputs[i].m_dirName = this.getNetworkManager().getWorksheetDirPath();
            SplusScriptEngineNode.g_bigdataScriptOutputs[i].m_dcfFilename = this.getNetworkManager().getOutputDataCacheFileName(this.getNodeID(), i);
            SplusScriptEngineNode.g_bigdataScriptOutputs[i].m_mdfFilename = this.getNetworkManager().getOutputMetaDataFileName(this.getNodeID(), i);
            SplusScriptEngineNode.g_bigdataScriptOutputs[i].m_dbfFilename = this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), i);
        }
        CNKProcSplusTransform proc = this.getInitTransformProc();
        this.procSetProperties(proc);
        proc.setCallback(this);
        this.m_modifyDynamicOutputsMetaDataProc = proc;
        boolean ok = this.getNetworkManager().executeCNKProcBase(this.getNodeID(), proc, new CNKBackingFileBuf[0], new CNKBackingFileBuf[0], 10, false);
        for (int i2 = 0; i2 < numOutputs; ++i2) {
            XTMetaData md = XTMetaData.readXTMetaDataFromFile(SplusScriptEngineNode.g_bigdataScriptOutputs[i2].m_mdfFilename);
            this.setOutputMetaData(i2, md);
        }
        proc.setCallback(null);
        this.procDelete(proc);
        g_bigdataScriptInputs = null;
        g_bigdataScriptOutputs = null;
        return ok;
    }

    private boolean executeSamplingScript() throws Exception {
        Random random = this.getRandomGenerator();
        long desiredRows = this.getSampleSize();
        int numInputs = this.getNumInputs();
        String[] sampledInputFilename = new String[numInputs];
        boolean[] sampledInputFilenameDelete = new boolean[numInputs];
        XTMetaData[] sampledInputMetaData = new XTMetaData[numInputs];
        for (int i = 0; i < numInputs; ++i) {
            XTMetaData inputMD = this.getInputMetaData(i);
            String origInputFilename = this.getInputDataCacheFileName(i);
            long inputRows = inputMD.getNumRows();
            if (inputRows <= desiredRows) {
                sampledInputFilename[i] = origInputFilename;
                sampledInputFilenameDelete[i] = false;
                sampledInputMetaData[i] = inputMD;
                continue;
            }
            File tFile = this.createWorkspaceTempFile("sample", "tmp");
            sampledInputFilename[i] = tFile.getAbsolutePath();
            sampledInputFilenameDelete[i] = true;
            tFile.deleteOnExit();
            long taken = this.sample(origInputFilename, inputMD, sampledInputFilename[i], desiredRows, random);
            sampledInputMetaData[i] = (XTMetaData)inputMD.copy();
            sampledInputMetaData[i].setNumRows(taken);
        }
        CNKProcSplusTransform proc = this.getInitTransformProc();
        this.procSetProperties(proc);
        proc.setCallback(this);
        this.m_modifyDynamicOutputsMetaDataProc = proc;
        boolean ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc, sampledInputFilename, sampledInputMetaData);
        proc.setCallback(null);
        this.procDelete(proc);
        for (int i = 0; i < numInputs; ++i) {
            if (!sampledInputFilenameDelete[i]) continue;
            new File(sampledInputFilename[i]).delete();
        }
        return ok;
    }

    private long sample(String inputFilename, XTMetaData inputMD, String outputFilename, long numRows, Random random) {
        long totalRowCount = inputMD.getNumRows();
        long rowCount = Math.min(totalRowCount, numRows);
        long taken = 0L;
        boolean noSampling = totalRowCount == rowCount;
        try {
            FileInputStream dataStream = new FileInputStream(inputFilename);
            BufferedInputStream dataBuffer = new BufferedInputStream(dataStream);
            DataInputStream dataInputStream = new DataInputStream(dataBuffer);
            DataCacheRowBuf inputBuf = new DataCacheRowBuf(inputMD);
            int bytesPerRow = inputBuf.getBytesPerRow();
            FileOutputStream outDataStream = new FileOutputStream(outputFilename);
            BufferedOutputStream outDataBuffer = new BufferedOutputStream(outDataStream);
            DataOutputStream outDataInputStream = new DataOutputStream(outDataBuffer);
            byte[] rowData = new byte[bytesPerRow];
            for (long i = 0L; i < totalRowCount; ++i) {
                dataInputStream.readFully(rowData, 0, bytesPerRow);
                if (!noSampling && !(random.nextDouble() * (double)(totalRowCount - i) < (double)(rowCount - taken))) continue;
                outDataInputStream.write(rowData, 0, bytesPerRow);
                if (++taken >= rowCount) break;
            }
            dataInputStream.close();
            outDataInputStream.close();
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return taken;
    }

    public void procExtractResults(CNKProc proc) {
        ++EngineNetworkManager.m_statSplusNodes;
        proc.setCallback(null);
        if (this.m_storeResultsForView) {
            try {
                XTProps textCache = new XTProps();
                if (this.m_localOutputHandler != null) {
                    textCache.set(TEXT_OUTPUT_ATTRIBUTE_TAG, this.m_localOutputHandler.getText());
                }
                this.setNodeCache(TEXT_OUTPUT_CACHE_NAME, textCache);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.m_localCanvasHandler != null) {
                    XTProps graphCache = new XTProps();
                    String[] tabPaneInfo = this.m_localCanvasHandler.getTabbedPanesAsText();
                    if (tabPaneInfo != null) {
                        for (int i = 0; i < tabPaneInfo.length; ++i) {
                            if (tabPaneInfo[i] == null) continue;
                            graphCache.set(GRAPH_OUTPUT_ATTRIBUTE_TAG, tabPaneInfo[i]);
                            this.setNodeCache(GRAPH_OUTPUT_CACHE_NAME + i, graphCache);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_localOutputHandler != null) {
            this.m_localOutputHandler.cleanup();
        }
        if (this.m_localCanvasHandler != null) {
            this.m_localCanvasHandler.cleanup();
        }
        this.m_localOutputHandler = null;
        this.m_localCanvasHandler = null;
    }

    private class LocalCanvasHandler
    implements SplusCanvasHandler {
        private Vector m_tabPaneVec;
        private SplusCanvasHandler m_origCanvasHandler = MinerApp.isInBDL() ? SplusSystem.getCanvasHandler() : MinerApp.getMainFrame();
        private boolean m_localShowDuringRun;
        private boolean m_localStoreForView;

        public LocalCanvasHandler(boolean showDuringRun, boolean storeForView) {
            this.m_tabPaneVec = new Vector();
            this.m_localShowDuringRun = showDuringRun;
            this.m_localStoreForView = storeForView;
        }

        public void useCustomHandler() {
            SplusSystem.setCanvasHandler((SplusCanvasHandler)this);
        }

        public void useDefaultHandler() {
            SplusSystem.setCanvasHandler((SplusCanvasHandler)this.m_origCanvasHandler);
        }

        public void showNewCanvas(SCanvas canvas) {
            if (this.m_localShowDuringRun) {
                MinerFrame mf = MinerApp.getMainFrame();
                GraphFrame gf = new GraphFrame(canvas, MinerFrame.getNextSplusGraphTitle(), mf.getAppIcon(), mf.getNextWindowLocation());
                this.m_tabPaneVec.add(gf.getCanvasTabbedPane());
            } else {
                CanvasTabbedPane tabPane = new CanvasTabbedPane();
                CanvasTabbedPane.setClearReaction(1);
                tabPane.setActiveCanvas(canvas);
                tabPane.addCanvasTab(canvas);
                this.m_tabPaneVec.add(tabPane);
            }
        }

        public SCanvas getActiveCanvas() {
            throw new RuntimeException("Method not implemented.");
        }

        public SCanvas getCurrentDeviceCanvas() {
            throw new RuntimeException("Method not implemented.");
        }

        public void addGraphWindow(GraphWindow window) {
            throw new RuntimeException("Method not implemented.");
        }

        public String[] getTabbedPanesAsText() {
            String[] result = null;
            if (!this.m_localStoreForView) {
                return null;
            }
            boolean noGraphs = true;
            int numTabPanes = this.m_tabPaneVec.size();
            if (numTabPanes > 0) {
                for (int i = 0; i < numTabPanes; ++i) {
                    if (((CanvasTabbedPane)this.m_tabPaneVec.get(0)).getTabCount() <= 0) continue;
                    noGraphs = false;
                }
            }
            if (noGraphs) {
                return null;
            }
            CanvasTabbedPane curTabPane = null;
            File outputFile = null;
            PrintWriter outputStream = null;
            FileInputStream inStream = null;
            result = new String[numTabPanes];
            for (int i = 0; i < numTabPanes; ++i) {
                outputFile = new File(SplusScriptEngineNode.this.getNetworkManager().getWorksheetDirPath(), SplusScriptEngineNode.this.getNodeID() + "-rawGraphOutput" + i + ".txt");
                outputFile.deleteOnExit();
                curTabPane = (CanvasTabbedPane)this.m_tabPaneVec.get(i);
                if (curTabPane.getTabCount() == 0) {
                    result[i] = null;
                    continue;
                }
                try {
                    outputStream = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
                    XML.writeCanvasVector((PrintWriter)outputStream, (Vector)curTabPane.getAllCanvases());
                    outputStream.flush();
                    outputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                long len = outputFile.length();
                if (len > Integer.MAX_VALUE) {
                    MinerApp.outputText("Graph description longer than 2147483647 bytes.  Cannot recover graph description.", 3, true);
                    result[i] = null;
                }
                byte[] buf = new byte[(int)len];
                try {
                    inStream = new FileInputStream(outputFile);
                    inStream.read(buf);
                    inStream.close();
                    result[i] = new String(buf, "UTF-8");
                }
                catch (Exception e) {
                    SplusScriptEngineNode.this.printlnError("Error reading graph output:  " + e.getMessage());
                }
                outputFile.delete();
            }
            return result;
        }

        public void cleanup() {
            if (!this.m_localShowDuringRun && this.m_tabPaneVec != null) {
                int numTabPanes = this.m_tabPaneVec.size();
                CanvasTabbedPane curTabPane = null;
                for (int i = 0; i < numTabPanes; ++i) {
                    curTabPane = (CanvasTabbedPane)this.m_tabPaneVec.get(i);
                    int deviceNumber = curTabPane.getDeviceNumber();
                    if (deviceNumber > 0) {
                        curTabPane.unlinkCanvases();
                        String devOffCmd = "{dev.off(" + deviceNumber + ");vector(\"missing\",0)}\n";
                        if (SplusSystem.getEngineQueryHandler() != null) {
                            SplusSystem.getEngineQueryHandler().processDataQuery(devOffCmd, 5);
                        }
                    }
                    curTabPane.removeAllTabs();
                    curTabPane = null;
                }
                this.m_tabPaneVec.removeAllElements();
            }
        }
    }

    private class LocalOutputHandler {
        private String m_textOutputFilename;
        private File m_textOutputFile;
        private FileOutputStream m_textOutputStream;
        private MinerOutputHandler m_minerOutputHandler = MinerApp.getMainFrame() == null ? null : MinerApp.getMainFrame().getOutputHandler();
        private boolean m_localShowDuringRun;
        private boolean m_localStoreForView;

        public LocalOutputHandler(boolean showDuringRun, boolean storeForView) {
            this.m_localShowDuringRun = showDuringRun;
            this.m_localStoreForView = storeForView;
            if (this.m_localStoreForView) {
                this.m_textOutputFile = new File(SplusScriptEngineNode.this.getNetworkManager().getWorksheetDirPath(), SplusScriptEngineNode.this.getNodeID() + "-rawTextOutput.txt");
                this.m_textOutputFile.deleteOnExit();
                this.m_textOutputFilename = this.m_textOutputFile.getAbsolutePath();
                try {
                    this.m_textOutputStream = new FileOutputStream(this.m_textOutputFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void useCustomHandler() {
            if (this.m_minerOutputHandler != null) {
                this.m_minerOutputHandler.setWriteToOutputPane(this.m_localShowDuringRun);
                if (this.m_localStoreForView) {
                    this.m_minerOutputHandler.setOutputStream(this.m_textOutputStream);
                }
            }
        }

        public void useDefaultHandler() {
            if (this.m_minerOutputHandler != null) {
                this.m_minerOutputHandler.setOutputStream(null);
                this.m_minerOutputHandler.setWriteToOutputPane(true);
            }
        }

        public String getText() {
            String result = null;
            if (this.m_textOutputStream != null) {
                try {
                    this.m_textOutputStream.flush();
                    this.m_textOutputStream.close();
                    this.m_textOutputStream = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.m_textOutputFile.exists() && this.m_textOutputFile.length() > 0L) {
                long len = this.m_textOutputFile.length();
                if (len > Integer.MAX_VALUE) {
                    SplusScriptEngineNode.this.printlnWarning("Text output has " + len + " bytes.  Truncating to " + Integer.MAX_VALUE + " bytes.");
                    len = Integer.MAX_VALUE;
                }
                byte[] buf = new byte[(int)len];
                try {
                    FileInputStream stream = new FileInputStream(this.m_textOutputFile);
                    stream.read(buf);
                    stream.close();
                    result = new String(buf);
                }
                catch (Exception e) {
                    SplusScriptEngineNode.this.printlnError("Error reading text output:  " + e.getMessage());
                }
            }
            return result;
        }

        public void cleanup() {
            try {
                if (this.m_textOutputFile != null) {
                    this.m_textOutputFile.delete();
                }
                this.m_textOutputFile = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class BigdataScriptCache {
        public XTMetaData m_metaData = null;
        public String m_dcfFilename = null;
        public String m_mdfFilename = null;
        public String m_dbfFilename = null;
        public String m_dirName = null;
    }
}

