/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerDistributionComboBox;
import com.insightful.miner.graphdlg.controls.MinerFunctionInfo;
import com.insightful.miner.graphdlg.controls.MinerGroupPanel;
import com.insightful.miner.graphdlg.controls.MinerTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class MinerDistributionParameterGroup
extends MinerGroupPanel {
    MinerDistributionComboBox distributionControl;
    ArrayList parameterControlList = new ArrayList();
    static final String[] distNames = new String[]{"beta", "binomial", "cauchy", "chisquare", "exponential", "f", "gamma", "geometric", "hypergeometric", "lognormal", "logistic", "negbinomial", "normal", "poisson", "t", "uniform", "weibull"};
    static HashMap enableMap = new HashMap();
    static final int[][] enableIndices = new int[][]{{6, 7}, {11, 12}, {4, 5}, {8}, {2}, {8, 9}, {6}, {11}, {12, 13, 14}, {2, 3}, {4, 5}, {10, 11}, {2, 3}, {2}, {8}, {0, 1}, {5, 6}};
    static final String[] prompts = new String[]{"Minimum", "Maximum", "Mean", "Std. Deviation", "Location", "Scale", "Shape 1", "Shape 2", "Deg of Freedom 1", "Deg of Freedom 2", "No. of Successes", "Probability", "Sample Size", "Total Successes", "Total Failures"};
    static final char[] mnemonics = new char[]{'N', 'X', 'M', 'O', 'L', 'C', 'H', 'P', '1', '2', '.', 'B', 'S', 'T', 'F'};
    static final String[] argNames = new String[]{"min", "max", "mean", "sd", "location", "scale", "shape1", "shape2", "df1", "df2", "k", "prob", "size", "m", "nhyper"};

    public MinerDistributionParameterGroup(MinerDistributionComboBox control) {
        super("Distribution Parameters");
        if (enableMap.isEmpty()) {
            for (int i = 0; i < distNames.length; ++i) {
                enableMap.put(distNames[i], enableIndices[i]);
            }
        }
        this.distributionControl = control;
        this.distributionControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinerDistributionParameterGroup.this.refreshEnabledStatus();
            }
        });
        for (int i = 0; i < prompts.length; ++i) {
            MinerTextField textField = new MinerTextField(prompts[i], mnemonics[i]);
            this.add(textField);
            this.parameterControlList.add(textField);
        }
        this.refreshEnabledStatus();
    }

    private void refreshEnabledStatus() {
        String dist = this.distributionControl.getValue();
        int[] inds = (int[])enableMap.get(dist);
        for (int i = 0; i < prompts.length; ++i) {
            MinerTextField textField = (MinerTextField)this.parameterControlList.get(i);
            boolean status = false;
            for (int j = 0; j < inds.length; ++j) {
                status |= inds[j] == i;
            }
            textField.setEnabled(status);
        }
    }

    public void registerControls(MinerFunctionInfo funcInfo) {
        for (int i = 1; i < prompts.length; ++i) {
            funcInfo.add((MinerTextField)this.parameterControlList.get(i), argNames[i]);
        }
    }

    public static String[] getDistributionNames() {
        return distNames;
    }

    public void setValues(String[] values) {
        int n = this.parameterControlList.size();
        if (n == values.length) {
            for (int i = 0; i < n; ++i) {
                ((MinerTextField)this.parameterControlList.get(i)).setValue(values[i]);
            }
        }
    }

    public String[] getValues() {
        int n = this.parameterControlList.size();
        String[] values = new String[n];
        for (int i = 0; i < n; ++i) {
            values[i] = ((MinerTextField)this.parameterControlList.get(i)).getValue();
        }
        return values;
    }

    public boolean warnIfEmpty() {
        String dist = this.distributionControl.getValue();
        int[] inds = (int[])enableMap.get(dist);
        boolean status = true;
        for (int i = 0; status && i < inds.length; ++i) {
            MinerTextField textField = (MinerTextField)this.parameterControlList.get(inds[i]);
            if (!textField.getValue().equals("")) continue;
            JOptionPane.showMessageDialog(this, textField.getText() + " field requires a value.", "Required Field Empty", 2);
            status = false;
        }
        return status;
    }
}

