/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.gui;

import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerPopupMenu;
import com.insightful.miner.PrintPreview;
import com.insightful.miner.tree.gui.ClassificationTreeGUI;
import com.insightful.miner.tree.gui.ColorBroker;
import com.insightful.miner.tree.model.ClassificationRegressionTreeNode;
import com.insightful.miner.tree.model.TreeCollection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DendrogramPanel
extends JPanel
implements Printable {
    private ClassificationRegressionTreeNode root = null;
    private ClassificationTreeGUI gui = null;
    private TreeCollection treeColl = null;
    private ClassificationRegressionTreeNode selectedNode = null;
    private TreePath selectionPath = null;
    private ClassificationRegressionTreeNode rightSelNode = null;
    private ClassificationRegressionTreeNode mouseOverNode = null;
    private boolean mapToDeviance = false;
    private boolean drawExplanationLine = true;
    private JScrollPane scrollPanel;
    private boolean showColors = false;
    private boolean showShading = false;
    private boolean showPath = false;
    private int treeHeight = 0;
    private int dendrogramHeight = 0;
    private int dendrogramWidth = 0;
    private int numLeaves = 0;
    private int treeCountIncrement = 8;
    private int yFactor = 4;
    private int xFactor = 1;
    private int startx = 20;
    private int starty = 50;
    private JPopupMenu nodeContextMenu = new MinerPopupMenu();
    private JMenuItem expandToHereMenuItem = new JMenuItem();
    private JMenuItem pruneMenuItem = new JMenuItem();
    private JPopupMenu contextMenu = new MinerPopupMenu();
    private JMenuItem diversityMapMenuItem = new JMenuItem();
    private JMenuItem noDiversityMapMenuItem = new JMenuItem();
    private JMenuItem zoomInMenuItem = new JMenuItem();
    private JMenuItem zoomOutMenuItem = new JMenuItem();
    private int scrollBarWidth;
    private int extraBuffer;
    private double totalDifference;
    boolean myPrintBegun;
    Dimension myPrintDocSize;
    Point myPrintDocTopLeft;
    Rectangle2D.Double myPrintPageRect;
    int myPrintNumPagesAcross;
    int myPrintNumPagesDown;
    double myPrintHorizScale;
    double myPrintVertScale;

    public DendrogramPanel(ClassificationTreeGUI ctgui, ClassificationRegressionTreeNode crroot, JScrollPane scrPanel) {
        this.scrollBarWidth = new JScrollBar().getPreferredSize().width;
        this.extraBuffer = 0;
        this.totalDifference = 0.0;
        this.myPrintBegun = false;
        this.myPrintDocSize = null;
        this.myPrintDocTopLeft = null;
        this.myPrintPageRect = null;
        this.myPrintNumPagesAcross = 1;
        this.myPrintNumPagesDown = 1;
        this.myPrintHorizScale = 1.0;
        this.myPrintVertScale = 1.0;
        this.root = crroot;
        this.gui = ctgui;
        this.treeColl = this.gui.getTreeCollection();
        this.scrollPanel = scrPanel;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(ColorBroker.getColor("dendrogramBackgroundColor"));
        if (this.treeColl.isRegression()) {
            this.extraBuffer = 40;
        }
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (!DendrogramPanel.this.hasFocus()) {
                    DendrogramPanel.this.requestFocus();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                DendrogramPanel.this.doMouseReleased(e);
            }

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DendrogramPanel.this.doMouseDblClick(e);
                }
                DendrogramPanel.this.doMousePressed(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                DendrogramPanel.this.doMouseMoved(e);
            }

            public void mouseDragged(MouseEvent e) {
            }
        });
        String selectnode = ClassificationTreeGUI.getText("treevis_dend_selectnode");
        this.expandToHereMenuItem.setText(selectnode);
        this.expandToHereMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DendrogramPanel.this.expandToHere(DendrogramPanel.this.rightSelNode);
            }
        });
        this.nodeContextMenu.add(this.expandToHereMenuItem);
        String prunenode = ClassificationTreeGUI.getText("treevis_dend_prunenode");
        this.pruneMenuItem.setText(prunenode);
        this.pruneMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DendrogramPanel.this.gui.pruneCurrentNode(DendrogramPanel.this.rightSelNode);
                DendrogramPanel.this.gui.updateUI();
            }
        });
        String zoomin = ClassificationTreeGUI.getText("treevis_dend_zoomin");
        this.zoomInMenuItem.setText(zoomin);
        this.zoomInMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DendrogramPanel.this.repaint();
            }
        });
        this.contextMenu.add(this.zoomInMenuItem);
        String zoomout = ClassificationTreeGUI.getText("treevis_dend_zoomout");
        this.zoomOutMenuItem.setText(zoomout);
        this.zoomOutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DendrogramPanel.this.repaint();
            }
        });
        this.contextMenu.add(this.zoomOutMenuItem);
    }

    public void computeSize() {
        int displayAreaHeight = this.scrollPanel.getHeight() - this.starty;
        int displayAreaWidth = this.getWidth();
        this.numLeaves = this.root.getLeafCount();
        this.treeHeight = this.treeCountIncrement * this.numLeaves;
        if (this.treeHeight < displayAreaHeight) {
            this.yFactor = displayAreaHeight / this.treeHeight;
            this.dendrogramHeight = super.getHeight();
            this.setSize(new Dimension(displayAreaWidth, this.dendrogramHeight));
            this.scrollPanel.setVerticalScrollBarPolicy(21);
            this.scrollPanel.setHorizontalScrollBarPolicy(31);
        } else {
            this.yFactor = 2;
            this.dendrogramHeight = this.starty + this.treeHeight * this.yFactor + this.starty;
            this.setSize(new Dimension(displayAreaWidth, this.dendrogramHeight));
            this.scrollPanel.setVerticalScrollBarPolicy(20);
            this.scrollPanel.setHorizontalScrollBarPolicy(30);
        }
        Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
        int count = 0;
        while (e.hasMoreElements()) {
            ClassificationRegressionTreeNode crtn = (ClassificationRegressionTreeNode)e.nextElement();
            if (!crtn.isLeaf()) continue;
            crtn.setDendYVal(count * this.yFactor);
            count += this.treeCountIncrement;
        }
        this.assignYVal(this.root);
        this.totalDifference = 0.0;
        this.getMaxDifference(this.root);
        this.assignXVal(this.root);
    }

    private int assignYVal(ClassificationRegressionTreeNode node) {
        if (node.isLeaf()) {
            return node.getDendYVal();
        }
        ClassificationRegressionTreeNode leftNode = (ClassificationRegressionTreeNode)node.getChildAt(0);
        ClassificationRegressionTreeNode rightNode = (ClassificationRegressionTreeNode)node.getChildAt(1);
        int yval = (this.assignYVal(leftNode) + this.assignYVal(rightNode)) / 2;
        node.setDendYVal(yval);
        return yval;
    }

    private void getMaxDifference(ClassificationRegressionTreeNode node) {
        this.nrGetMaxDifference(node);
    }

    private void rGetMaxDifference(ClassificationRegressionTreeNode node) {
        if (!node.isLeaf()) {
            this.rGetMaxDifference((ClassificationRegressionTreeNode)node.getChildAt(0));
            this.rGetMaxDifference((ClassificationRegressionTreeNode)node.getChildAt(1));
        } else {
            ClassificationRegressionTreeNode aNode = node;
            double newTotal = 0.0;
            while (aNode != this.root) {
                ClassificationRegressionTreeNode parent = (ClassificationRegressionTreeNode)aNode.getParent();
                ClassificationRegressionTreeNode child1 = (ClassificationRegressionTreeNode)parent.getChildAt(0);
                ClassificationRegressionTreeNode child2 = (ClassificationRegressionTreeNode)parent.getChildAt(1);
                double diversityDifference = parent.getDeviance() - (child1.getDeviance() + child2.getDeviance());
                newTotal += diversityDifference;
                aNode = parent;
            }
            if (newTotal > this.totalDifference) {
                this.totalDifference = newTotal;
            }
        }
    }

    private void nrGetMaxDifference(ClassificationRegressionTreeNode firstNode) {
        Enumeration<TreeNode> avoidRecursion = firstNode.preorderEnumeration();
        while (avoidRecursion.hasMoreElements()) {
            ClassificationRegressionTreeNode nrNode = (ClassificationRegressionTreeNode)avoidRecursion.nextElement();
            if (!nrNode.isLeaf()) continue;
            ClassificationRegressionTreeNode aNode = nrNode;
            double newTotal = 0.0;
            while (aNode != this.root) {
                ClassificationRegressionTreeNode parent = (ClassificationRegressionTreeNode)aNode.getParent();
                ClassificationRegressionTreeNode child1 = (ClassificationRegressionTreeNode)parent.getChildAt(0);
                ClassificationRegressionTreeNode child2 = (ClassificationRegressionTreeNode)parent.getChildAt(1);
                double diversityDifference = parent.getDeviance() - (child1.getDeviance() + child2.getDeviance());
                newTotal += diversityDifference;
                aNode = parent;
            }
            if (!(newTotal > this.totalDifference)) continue;
            this.totalDifference = newTotal;
        }
    }

    private void assignXVal(ClassificationRegressionTreeNode node) {
        this.nrAssignXVal(node);
    }

    private void nrAssignXVal(ClassificationRegressionTreeNode firstNode) {
        Enumeration<TreeNode> avoidRecursion = firstNode.preorderEnumeration();
        while (avoidRecursion.hasMoreElements()) {
            ClassificationRegressionTreeNode iterNode = (ClassificationRegressionTreeNode)avoidRecursion.nextElement();
            if (this.mapToDeviance) {
                if (iterNode == this.root) {
                    iterNode.setDendXVal(this.startx);
                    continue;
                }
                ClassificationRegressionTreeNode parent = (ClassificationRegressionTreeNode)iterNode.getParent();
                ClassificationRegressionTreeNode child1 = (ClassificationRegressionTreeNode)parent.getChildAt(0);
                ClassificationRegressionTreeNode child2 = (ClassificationRegressionTreeNode)parent.getChildAt(1);
                double diversityDifference = parent.getDeviance() - (child1.getDeviance() + child2.getDeviance());
                parent.setDiversityDifference(diversityDifference);
                int xlength = (int)(diversityDifference / this.totalDifference * (double)(this.scrollPanel.getWidth() - this.scrollBarWidth - 50 - this.extraBuffer));
                if (xlength < 5) {
                    xlength = 5;
                }
                iterNode.setDendXVal(((ClassificationRegressionTreeNode)iterNode.getParent()).getDendXVal() + xlength);
                continue;
            }
            this.xFactor = (this.scrollPanel.getWidth() - this.scrollBarWidth - 30 - this.extraBuffer) / (this.root.getDepth() == 0 ? 1 : this.root.getDepth());
            if (this.xFactor < 5) {
                this.xFactor = 5;
            }
            iterNode.setDendXVal(iterNode.getLevel() * this.xFactor);
        }
    }

    private void rAssignXVal(ClassificationRegressionTreeNode node) {
        if (this.mapToDeviance) {
            if (node == this.root) {
                node.setDendXVal(this.startx);
            } else {
                ClassificationRegressionTreeNode parent = (ClassificationRegressionTreeNode)node.getParent();
                ClassificationRegressionTreeNode child1 = (ClassificationRegressionTreeNode)parent.getChildAt(0);
                ClassificationRegressionTreeNode child2 = (ClassificationRegressionTreeNode)parent.getChildAt(1);
                double diversityDifference = parent.getDeviance() - (child1.getDeviance() + child2.getDeviance());
                parent.setDiversityDifference(diversityDifference);
                int xlength = (int)(diversityDifference / this.totalDifference * (double)(this.scrollPanel.getWidth() - this.scrollBarWidth - 50 - this.extraBuffer));
                if (xlength < 5) {
                    xlength = 5;
                }
                node.setDendXVal(((ClassificationRegressionTreeNode)node.getParent()).getDendXVal() + xlength);
            }
        } else {
            this.xFactor = (this.scrollPanel.getWidth() - this.scrollBarWidth - 30 - this.extraBuffer) / (this.root.getDepth() == 0 ? 1 : this.root.getDepth());
            if (this.xFactor < 5) {
                this.xFactor = 5;
            }
            node.setDendXVal(node.getLevel() * this.xFactor);
        }
        if (!node.isLeaf()) {
            this.rAssignXVal((ClassificationRegressionTreeNode)node.getChildAt(0));
            this.rAssignXVal((ClassificationRegressionTreeNode)node.getChildAt(1));
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.root.getDepth() == 0) {
            g.setColor(ColorBroker.getColor("nodeDetailsColor"));
            g.setFont(MinerApp.getFont(1, 9));
            String devexp1a1 = ClassificationTreeGUI.getText("treevis_dend_homogenous_tree1");
            g.drawString(devexp1a1, 10, 12);
            String devexp1a2 = ClassificationTreeGUI.getText("treevis_dend_homogenous_tree2");
            g.drawString(devexp1a2, 10, 22);
            String devexp1a3 = ClassificationTreeGUI.getText("treevis_dend_homogenous_tree3");
            g.drawString(devexp1a3, 10, 32);
            return;
        }
        if (this.selectedNode != null && this.selectedNode.isLeaf()) {
            g.setColor(ColorBroker.getColor("dendrogramLeafSelectionColor"));
            g.fillArc(this.selectedNode.getDendXVal() - 10 + this.startx, this.selectedNode.getDendYVal() - 10 + this.starty, 20, 20, 0, 360);
        }
        if (this.root == this.selectedNode) {
            this.paintTree(g, this.root, true);
        } else {
            this.paintTree(g, this.root, false);
        }
        if (this.mapToDeviance) {
            this.drawDiversityMapExplanation(g, this.selectedNode);
        }
        if (this.showShading) {
            this.drawShadingExplanation(g, this.selectedNode);
        }
    }

    private void drawDiversityMapExplanation(Graphics g, ClassificationRegressionTreeNode node) {
        if (node == null) {
            node = this.root;
        }
        if (node.isLeaf()) {
            return;
        }
        ClassificationRegressionTreeNode child = (ClassificationRegressionTreeNode)node.getChildAt(0);
        int xloc = (child.getDendXVal() + node.getDendXVal()) / 2 + this.startx;
        double dd = node.getDiversityDifference();
        g.setColor(ColorBroker.getColor("explanationColor"));
        g.setFont(MinerApp.getFont(1, 9));
        String devexp1a = ClassificationTreeGUI.getText("treevis_dend_diversityExp1A");
        String devexp1b = ClassificationTreeGUI.getText("treevis_dend_diversityExp1B");
        String devexp2 = "";
        String crit = this.treeColl.getCriterion();
        if (this.treeColl.isRegression()) {
            devexp2 = ClassificationTreeGUI.getText("treevis_dend_diversityExp2d");
        } else if (this.treeColl.miningSchema_attribute_entropy_value.equals(crit)) {
            devexp2 = ClassificationTreeGUI.getText("treevis_dend_diversityExp2c");
        } else if (this.treeColl.miningSchema_attribute_gini_value.equals(crit)) {
            devexp2 = ClassificationTreeGUI.getText("treevis_dend_diversityExp2b");
        } else {
            System.out.println("Error: unsupported tree type (" + crit + ").");
            devexp2 = ClassificationTreeGUI.getText("treevis_dend_diversityExp2");
        }
        String devexp3 = ClassificationTreeGUI.getText("treevis_dend_diversityExp3");
        if (node == this.root) {
            g.drawString(devexp1a, 10, 12);
        } else {
            g.drawString(devexp1b, 10, 12);
        }
        g.drawString(" " + devexp2, 10, 22);
        g.drawString(" " + devexp3 + " ", 10, 32);
        g.setColor(ColorBroker.getColor("dendrogramSelectedColor"));
        g.drawString(MinerApp.formatDouble(dd), 30, 32);
        g.setColor(ColorBroker.getColor("explanationColor"));
        if (this.drawExplanationLine) {
            g.drawLine(40, 40, xloc, child.getDendYVal() + this.starty - 6);
        }
        g.drawLine(node.getDendXVal() + this.startx, child.getDendYVal() + this.starty - 6, child.getDendXVal() + this.startx - 4, child.getDendYVal() + this.starty - 6);
        g.drawLine(node.getDendXVal() + this.startx, child.getDendYVal() + this.starty - 6, node.getDendXVal() + this.startx, child.getDendYVal() + this.starty - 3);
        g.drawLine(child.getDendXVal() + this.startx - 4, child.getDendYVal() + this.starty - 6, child.getDendXVal() + this.startx - 4, child.getDendYVal() + this.starty - 3);
    }

    private void drawShadingExplanation(Graphics g, ClassificationRegressionTreeNode node) {
        if (node == null) {
            node = this.root;
        }
        if (node.isLeaf()) {
            return;
        }
        g.setColor(ColorBroker.getColor("explanationColor"));
        g.setFont(MinerApp.getFont(1, 9));
        g.drawString("Dark paths indicate more records.", 150, 12);
    }

    public void paintTree(Graphics g, ClassificationRegressionTreeNode node, boolean isSelectedNode) {
        this.nrPaintTree(g, node, isSelectedNode);
    }

    public void nrPaintTree(Graphics g, ClassificationRegressionTreeNode firstNode, boolean firstSelectedNode) {
        Enumeration<TreeNode> avoidRecursion = firstNode.preorderEnumeration();
        Stack selStack = new Stack();
        boolean isSelectedNode = firstSelectedNode;
        int unselectNodeNum = -1;
        for (ClassificationRegressionTreeNode testNode = this.selectedNode; testNode != null; testNode = (ClassificationRegressionTreeNode)testNode.getParent()) {
            ClassificationRegressionTreeNode testSibling = (ClassificationRegressionTreeNode)testNode.getNextSibling();
            if (testSibling == null) continue;
            unselectNodeNum = testSibling.getPreOrderPosition();
            break;
        }
        while (avoidRecursion.hasMoreElements()) {
            ClassificationRegressionTreeNode node = (ClassificationRegressionTreeNode)avoidRecursion.nextElement();
            int preOrd = node.getPreOrderPosition();
            int x = this.startx + node.getDendXVal();
            int y = this.starty + node.getDendYVal();
            boolean bl = isSelectedNode = isSelectedNode && preOrd != unselectNodeNum || node == this.selectedNode;
            if (isSelectedNode) {
                g.setColor(ColorBroker.getColor("dendrogramSelectedColor"));
            } else if (!node.isLeaf() && this.showShading) {
                g.setColor(ColorBroker.getColorShading(node.getRecordRatio()));
            } else if (this.showColors) {
                g.setColor(node.getColor());
            } else {
                g.setColor(Color.black);
            }
            g.fillArc(x - 2, y - 2, 5, 5, 0, 360);
            g.setFont(MinerApp.getFont(1, 10));
            if (node.isLeaf()) {
                g.drawString(node.getYvalProbStr(), x + 7, y + 3);
                continue;
            }
            if (this.showPath && this.selectionPath != null) {
                g.setColor(ColorBroker.getColor("nodeDetailsColor"));
                for (int i = 0; i < this.selectionPath.getPathCount(); ++i) {
                    if (node != (ClassificationRegressionTreeNode)this.selectionPath.getPathComponent(i)) continue;
                    g.drawString(node.getNodeSplit(), x + 7, y + 3);
                }
            }
            for (int n = 0; n < 2; ++n) {
                ClassificationRegressionTreeNode childNode = (ClassificationRegressionTreeNode)node.getChildAt(n);
                if (isSelectedNode) {
                    g.setColor(ColorBroker.getColor("dendrogramSelectedColor"));
                } else if (this.showShading) {
                    g.setColor(ColorBroker.getColorShading(childNode.getRecordRatio()));
                } else {
                    g.setColor(Color.black);
                }
                g.drawLine(x, y, x, this.starty + childNode.getDendYVal());
                g.drawLine(x, this.starty + childNode.getDendYVal(), this.startx + childNode.getDendXVal(), this.starty + childNode.getDendYVal());
            }
        }
    }

    public void rPaintTree(Graphics g, ClassificationRegressionTreeNode node, boolean isSelectedNode) {
        int x = this.startx + node.getDendXVal();
        int y = this.starty + node.getDendYVal();
        if (isSelectedNode) {
            g.setColor(ColorBroker.getColor("dendrogramSelectedColor"));
        } else if (!node.isLeaf() && this.showShading) {
            g.setColor(ColorBroker.getColorShading(node.getRecordRatio()));
        } else if (this.showColors) {
            g.setColor(node.getColor());
        } else {
            g.setColor(Color.black);
        }
        g.fillArc(x - 2, y - 2, 5, 5, 0, 360);
        g.setFont(MinerApp.getFont(1, 10));
        if (node.isLeaf()) {
            g.drawString(node.getYvalProbStr(), x + 7, y + 3);
            return;
        }
        if (this.showPath && this.selectionPath != null) {
            g.setColor(ColorBroker.getColor("nodeDetailsColor"));
            for (int i = 0; i < this.selectionPath.getPathCount(); ++i) {
                if (node != (ClassificationRegressionTreeNode)this.selectionPath.getPathComponent(i)) continue;
                g.drawString(node.getNodeSplit(), x + 7, y + 3);
            }
        }
        ClassificationRegressionTreeNode leftNode = (ClassificationRegressionTreeNode)node.getChildAt(0);
        ClassificationRegressionTreeNode rightNode = (ClassificationRegressionTreeNode)node.getChildAt(1);
        if (isSelectedNode) {
            g.setColor(ColorBroker.getColor("dendrogramSelectedColor"));
        } else if (this.showShading) {
            g.setColor(ColorBroker.getColorShading(leftNode.getRecordRatio()));
        } else {
            g.setColor(Color.black);
        }
        g.drawLine(x, y, x, this.starty + leftNode.getDendYVal());
        g.drawLine(x, this.starty + leftNode.getDendYVal(), this.startx + leftNode.getDendXVal(), this.starty + leftNode.getDendYVal());
        if (isSelectedNode) {
            g.setColor(ColorBroker.getColor("dendrogramSelectedColor"));
        } else if (this.showShading) {
            g.setColor(ColorBroker.getColorShading(rightNode.getRecordRatio()));
        } else {
            g.setColor(Color.black);
        }
        g.drawLine(x, y, x, this.starty + rightNode.getDendYVal());
        g.drawLine(x, this.starty + rightNode.getDendYVal(), this.startx + rightNode.getDendXVal(), this.starty + rightNode.getDendYVal());
        if (isSelectedNode || leftNode == this.selectedNode) {
            this.rPaintTree(g, leftNode, true);
        } else {
            this.rPaintTree(g, leftNode, false);
        }
        if (isSelectedNode || rightNode == this.selectedNode) {
            this.rPaintTree(g, rightNode, true);
        } else {
            this.rPaintTree(g, rightNode, false);
        }
    }

    public void setSelected(ClassificationRegressionTreeNode n) {
        this.selectedNode = n;
    }

    public void setSelectionPath(TreePath tp) {
        this.selectionPath = tp;
    }

    private void doMousePressed(MouseEvent e) {
        this.rightSelNode = this.getNodeAtLocation(this.root, e.getX(), e.getY());
        if (this.rightSelNode == null) {
            this.selectedNode = null;
            this.selectionPath = null;
            this.gui.getJTree().setSelectionPath(null);
            this.repaint();
        } else {
            this.expandToHere(this.rightSelNode);
        }
        this.drawExplanationLine = false;
    }

    private void doMouseMoved(MouseEvent e) {
        this.mouseOverNode = this.getNodeAtLocation(this.root, e.getX(), e.getY());
    }

    private void doMouseReleased(MouseEvent e) {
    }

    private void doMouseDblClick(MouseEvent e) {
    }

    private ClassificationRegressionTreeNode getNodeAtLocation(ClassificationRegressionTreeNode node, int x, int y) {
        return this.nrGetNodeAtLocation(node, x, y);
    }

    private ClassificationRegressionTreeNode rGetNodeAtLocation(ClassificationRegressionTreeNode node, int x, int y) {
        if (Math.abs(node.getDendXVal() + this.startx - x) < 5 && Math.abs(node.getDendYVal() + this.starty - y) < 5) {
            return node;
        }
        if (node.isLeaf()) {
            return null;
        }
        ClassificationRegressionTreeNode child = this.getNodeAtLocation((ClassificationRegressionTreeNode)node.getChildAt(0), x, y);
        if (child != null) {
            return child;
        }
        child = this.getNodeAtLocation((ClassificationRegressionTreeNode)node.getChildAt(1), x, y);
        if (child != null) {
            return child;
        }
        return null;
    }

    private ClassificationRegressionTreeNode nrGetNodeAtLocation(ClassificationRegressionTreeNode firstNode, int x, int y) {
        Enumeration<TreeNode> avoidRecursion = firstNode.preorderEnumeration();
        while (avoidRecursion.hasMoreElements()) {
            ClassificationRegressionTreeNode node = (ClassificationRegressionTreeNode)avoidRecursion.nextElement();
            if (Math.abs(node.getDendXVal() + this.startx - x) >= 5 || Math.abs(node.getDendYVal() + this.starty - y) >= 5) continue;
            return node;
        }
        return null;
    }

    public void setDiversityMap(boolean flag) {
        this.mapToDeviance = flag;
    }

    public boolean getDiversityMap() {
        return this.mapToDeviance;
    }

    public boolean getShowColors() {
        return this.showColors;
    }

    public void setShowShading(boolean flag) {
        this.showShading = flag;
    }

    public boolean getShowShading() {
        return this.showShading;
    }

    public void setShowColors(boolean flag) {
        this.showColors = flag;
    }

    public void setDrawExplanationLine(boolean flag) {
        this.drawExplanationLine = flag;
    }

    public void setShowPath(boolean flag) {
        this.showPath = flag;
    }

    public boolean getShowPath() {
        return this.showPath;
    }

    public void resetRoot(ClassificationRegressionTreeNode r) {
        this.root = r;
    }

    public String getToolTipString() {
        String s = "";
        if (this.mouseOverNode != null) {
            s = s + this.mouseOverNode.getNodeSplit();
        }
        return s;
    }

    private void expandToHere(ClassificationRegressionTreeNode node) {
        Object[] path = node.getPath();
        TreePath tp = new TreePath(path);
        this.gui.getJTree().setSelectionPath(tp);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public int getHeight() {
        if (this.dendrogramHeight == 0) {
            return super.getHeight();
        }
        return this.dendrogramHeight;
    }

    public void setHeight(int val) {
        this.dendrogramHeight = val;
    }

    public int getWidth() {
        if (this.dendrogramWidth == 0) {
            return super.getWidth();
        }
        return this.dendrogramWidth;
    }

    public void setWidth(int val) {
        this.dendrogramWidth = val;
    }

    public DendrogramPanel getMainPanel() {
        return this;
    }

    public void printPreview() {
        Thread runner = new Thread(){

            public void run() {
                Component comp = MinerApp.getMainFrame().getGlassPane();
                Cursor oldCursor = comp.getCursor();
                comp.setCursor(Cursor.getPredefinedCursor(3));
                comp.setVisible(true);
                new PrintPreview(DendrogramPanel.this.getMainPanel(), DendrogramPanel.this.scrollPanel);
                comp.setCursor(oldCursor);
                comp.setVisible(false);
            }
        };
        runner.start();
    }

    public void print() {
        PrintThread thrd = new PrintThread(this);
        thrd.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics g, PageFormat pf, int pnum) {
        Point myOrigin = new Point();
        Graphics2D g2 = (Graphics2D)g;
        if (!this.myPrintBegun) {
            this.myPrintBegun = true;
            this.myPrintDocTopLeft = new Point((int)this.getAlignmentX(), (int)this.getAlignmentY());
            this.myPrintDocSize = this.getSize();
            int docWidth = this.myPrintDocSize.width;
            int docHeight = this.myPrintDocSize.height;
            this.myPrintPageRect = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
            double pageWidth = this.myPrintPageRect.width;
            double pageHeight = this.myPrintPageRect.height;
            this.myPrintVertScale = this.myPrintHorizScale = this.myPrintPageRect.width / (double)this.myPrintDocSize.width;
            this.myPrintNumPagesAcross = (int)Math.ceil((double)docWidth * this.myPrintHorizScale / pageWidth);
            this.myPrintNumPagesDown = (int)Math.ceil((double)docHeight * this.myPrintVertScale / pageHeight);
        }
        double pageX = this.myPrintPageRect.x;
        double pageY = this.myPrintPageRect.y;
        double pageWidth = this.myPrintPageRect.width;
        double pageHeight = this.myPrintPageRect.height;
        if (pnum >= this.myPrintNumPagesAcross * this.myPrintNumPagesDown) {
            this.myPrintBegun = false;
            return 1;
        }
        int hpnum = pnum % this.myPrintNumPagesAcross;
        int vpnum = pnum / this.myPrintNumPagesAcross;
        try {
            myOrigin = new Point((int)(((double)this.myPrintDocTopLeft.x + (double)hpnum * pageWidth) / this.myPrintHorizScale), (int)(((double)this.myPrintDocTopLeft.y + (double)vpnum * pageHeight) / this.myPrintVertScale));
            g2.clip(this.myPrintPageRect);
            Rectangle clipRect = new Rectangle();
            g2.getClipBounds(clipRect);
            clipRect.x -= (int)pageX;
            clipRect.y -= (int)pageY;
            clipRect.x = (int)((double)clipRect.x / this.myPrintHorizScale) + myOrigin.x;
            clipRect.y = (int)((double)clipRect.y / this.myPrintVertScale) + myOrigin.y;
            clipRect.width = (int)Math.ceil((double)clipRect.width / this.myPrintHorizScale);
            clipRect.height = (int)Math.ceil((double)clipRect.height / this.myPrintVertScale);
            g2.translate(pageX, pageY);
            g2.translate(-myOrigin.x, -myOrigin.y);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.paint(g2);
            Object var18_15 = null;
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            throw throwable;
        }
        return 0;
    }

    protected class PrintThread
    extends Thread {
        private DendrogramPanel m_ui;

        public PrintThread(DendrogramPanel ui) {
            this.m_ui = ui;
        }

        public void run() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            if (pj.printDialog(MinerApp.getPrintAttributeSet())) {
                PageFormat pf = pj.validatePage(MinerApp.getDefaultPageFormat());
                Paper paper = pf.getPaper();
                double margin = 36.0;
                paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
                pf.setPaper(paper);
                pj.setPrintable(this.m_ui, pf);
                new MinerApp.GenericPrintThread(pj).start();
            }
            MinerApp.getMainFrame().requestFocus();
            this.m_ui.requestFocus();
        }
    }
}

