/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.webdavaccess.client;

import com.insightful.webdavaccess.client.WebdavInfo;
import com.insightful.webdavaccess.client.WebdavProperty;
import com.insightful.webdavaccess.exceptions.WebdavException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.methods.CopyMethod;
import org.apache.webdav.lib.methods.MkcolMethod;
import org.apache.webdav.lib.methods.MoveMethod;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.apache.webdav.lib.util.WebdavStatus;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebdavClient {
    private final HttpClient httpClient = new HttpClient();
    private String userName;
    private String password;
    private static final String logging = "org.apache.commons.logging";
    private int currentStatusCode = 200;
    private static String[] RESULT_ELEMENTS;

    public WebdavClient() {
    }

    public WebdavClient(String user, String passwd) {
        this.setCredentials(user, passwd);
    }

    public void setCredentials(String user, String passwd) {
        this.userName = user;
        this.password = passwd;
        if (this.userName != null && this.password != null) {
            this.httpClient.getParams().setAuthenticationPreemptive(true);
            HttpState state = this.httpClient.getState();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.userName, this.password);
            state.setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
    }

    private Credentials setCredentials() {
        if (this.userName != null && this.password != null) {
            return new UsernamePasswordCredentials(this.userName, this.password);
        }
        return null;
    }

    public int getCurrentStatusCode() {
        return this.currentStatusCode;
    }

    public String getCurrentStatusMessage() {
        return WebdavStatus.getStatusText((int)this.currentStatusCode);
    }

    public boolean doDownloadFile(String url, File file) throws WebdavException {
        try {
            URI hrl = new URI(url, true);
            WebdavResource wdr = new WebdavResource(hrl.getEscapedURIReference(), this.setCredentials(), true);
            boolean status = wdr.getMethod(file);
            this.currentStatusCode = wdr.getStatusCode();
            return status;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    public boolean doUploadFile(String url, File file) throws WebdavException {
        try {
            int idx = url.lastIndexOf(47);
            if (idx < 0) {
                return false;
            }
            String filename = url.substring(idx + 1);
            url = url.substring(0, idx);
            URI hrl = new URI(url, true);
            WebdavResource wdr = new WebdavResource(hrl.getEscapedURIReference(), this.setCredentials(), true);
            boolean status = wdr.putMethod(wdr.getPath() + "/" + filename, (InputStream)new FileInputStream(file));
            this.currentStatusCode = wdr.getStatusCode();
            return status;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    public Vector getList(String url) throws WebdavException {
        try {
            URI hrl = new URI(url, true);
            WebdavResource wdr = new WebdavResource(hrl.getEscapedURIReference(), this.setCredentials(), true);
            Vector<WebdavInfo> results = new Vector<WebdavInfo>();
            if (!wdr.isCollection()) {
                this.currentStatusCode = 200;
                return results;
            }
            WebdavResource[] flist = wdr.listWebdavResources();
            if (flist == null) {
                this.currentStatusCode = 200;
                return results;
            }
            for (int i = 0; i < flist.length; ++i) {
                WebdavResource fwdr = flist[i];
                WebdavInfo info = this.createWebdavInfo(fwdr);
                results.add(info);
            }
            this.currentStatusCode = 200;
            return results;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    public WebdavInfo getInfo(String url) throws WebdavException {
        try {
            URI hrl = new URI(url, true);
            WebdavResource wdr = new WebdavResource(hrl.getEscapedURIReference(), this.setCredentials(), true);
            WebdavInfo info = this.createWebdavInfo(wdr);
            this.currentStatusCode = 200;
            return info;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    private WebdavInfo createWebdavInfo(WebdavResource fwdr) {
        WebdavInfo info = new WebdavInfo();
        info.setName(fwdr.getName());
        info.setDisplayName(fwdr.getDisplayName());
        long time = fwdr.getCreationDate();
        info.setCreationDate(new Date(time));
        time = fwdr.getGetLastModified();
        info.setLastModifiedDate(new Date(time));
        info.setLength(fwdr.getGetContentLength());
        info.setType(fwdr.getGetContentType());
        info.setPath(fwdr.toString());
        info.setOwner(fwdr.getOwner());
        info.setFolder(fwdr.isCollection());
        return info;
    }

    public boolean doCopy(String uri, String responseBodyFileName, String[] requestHeaderNames, String[] requestHeaderValues, String destination, boolean overwrite, String depth) throws WebdavException {
        Vector results = null;
        try {
            CopyMethod methodObj = new CopyMethod(uri, destination, overwrite);
            if (depth != null && !depth.equals("")) {
                methodObj.setDepth(WebdavClient.getDepthCode(depth));
            }
            results = this.executeMethodObject((HttpMethod)methodObj, responseBodyFileName, requestHeaderNames, requestHeaderValues);
            this.currentStatusCode = methodObj.getStatusCode();
            return methodObj.getStatusCode() == 200 || methodObj.getStatusCode() == 201;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    public boolean doCopy(String uri, String destination, boolean overwrite, String depth) throws WebdavException {
        return this.doCopy(uri, null, null, null, destination, overwrite, depth);
    }

    public boolean doCopy(String uri, String destination, boolean overwrite) throws WebdavException {
        return this.doCopy(uri, null, null, null, destination, overwrite, "infinity");
    }

    public boolean doLock(String url, String user, int duration) throws WebdavException {
        try {
            URI hrl = new URI(url, true);
            WebdavResource wdr = new WebdavResource(hrl.getEscapedURIReference(), this.setCredentials(), true);
            boolean status = wdr.lockMethod(user, duration);
            this.currentStatusCode = wdr.getStatusCode();
            return status;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    public boolean doUnock(String url) throws WebdavException {
        try {
            URI hrl = new URI(url, true);
            WebdavResource wdr = new WebdavResource(hrl.getEscapedURIReference(), this.setCredentials(), true);
            boolean status = wdr.unlockMethod();
            this.currentStatusCode = wdr.getStatusCode();
            return status;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    public boolean doMkcol(String uri, String responseBodyFileName, String[] requestHeaderNames, String[] requestHeaderValues) throws WebdavException {
        Vector results = null;
        try {
            MkcolMethod methodObj = new MkcolMethod(uri);
            results = this.executeMethodObject((HttpMethod)methodObj, responseBodyFileName, requestHeaderNames, requestHeaderValues);
            this.currentStatusCode = methodObj.getStatusCode();
            return methodObj.getStatusCode() == 201 || methodObj.getStatusCode() == 200;
        }
        catch (Exception e) {
            throw new WebdavException(e);
        }
    }

    public boolean createFolder(String uri) throws WebdavException {
        return this.doMkcol(uri, null, null, null);
    }

    public boolean doMove(String uri, String responseBodyFileName, String[] requestHeaderNames, String[] requestHeaderValues, String destination, boolean overwrite) throws WebdavException {
        Vector results = null;
        try {
            MoveMethod methodObj = new MoveMethod(uri, destination, overwrite);
            results = this.executeMethodObject((HttpMethod)methodObj, responseBodyFileName, requestHeaderNames, requestHeaderValues);
            this.currentStatusCode = methodObj.getStatusCode();
            return methodObj.getStatusCode() == 200 || methodObj.getStatusCode() == 201 || methodObj.getStatusCode() == 204;
        }
        catch (Exception e) {
            throw new WebdavException(e);
        }
    }

    public boolean doMove(String uri, String destination, boolean overwrite) throws WebdavException {
        return this.doMove(uri, null, null, null, destination, overwrite);
    }

    public boolean doDelete(String url) throws WebdavException {
        try {
            URI hrl = new URI(url, true);
            WebdavResource wdr = new WebdavResource(hrl.getEscapedURIReference(), this.setCredentials(), true);
            boolean status = wdr.deleteMethod();
            this.currentStatusCode = wdr.getStatusCode();
            return status;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    public boolean doExists(String url) throws WebdavException {
        WebdavResource wdr = null;
        try {
            URI hrl = new URI(url, true);
            wdr = new WebdavResource(hrl.getEscapedURIReference(), this.setCredentials(), true);
            wdr.setProperties(0);
            boolean status = wdr.exists();
            this.currentStatusCode = wdr.getStatusCode();
            return status;
        }
        catch (Exception e) {
            this.currentStatusCode = wdr != null ? wdr.getStatusCode() : 420;
            if (this.currentStatusCode == 404) {
                return false;
            }
            throw new WebdavException(e);
        }
    }

    public boolean doIsCollection(String url) throws WebdavException {
        WebdavResource wdr = null;
        try {
            URI hrl = new URI(url, true);
            wdr = new WebdavResource(hrl.getEscapedURIReference(), this.setCredentials(), true);
            wdr.setProperties(0);
            boolean status = wdr.isCollection();
            this.currentStatusCode = wdr.getStatusCode();
            return status;
        }
        catch (Exception e) {
            this.currentStatusCode = wdr != null ? wdr.getStatusCode() : 420;
            if (this.currentStatusCode == 404) {
                return false;
            }
            throw new WebdavException(e);
        }
    }

    public Vector doPropFind(String uri, String responseBodyFileName, String[] requestHeaderNames, String[] requestHeaderValues, String[] propNames, String depth, String type) throws WebdavException {
        Vector results = null;
        try {
            PropFindMethod methodObj = new PropFindMethod(uri){

                public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
                    super.addRequestHeaders(state, conn);
                    super.setRequestHeader("Content-Length", Integer.toString(this.generateRequestBody().length()));
                }
            };
            if (depth != null && !depth.equals("")) {
                methodObj.setDepth(WebdavClient.getDepthCode(depth));
            }
            if (type != null && !type.equals("")) {
                methodObj.setType(WebdavClient.getPropFindTypeCode(type));
            }
            if (propNames != null && propNames.length > 0) {
                Enumeration<String> en = new Vector<String>(Arrays.asList(propNames)).elements();
                methodObj.setPropertyNames(en);
            }
            results = this.executeMethodObject((HttpMethod)methodObj, responseBodyFileName, requestHeaderNames, requestHeaderValues);
            if (methodObj.getResponseDocument() != null && methodObj.getResponseDocument().getDocumentElement() != null) {
                results.set(results.size() - 1, WebdavClient.storeResponseDocument((XMLResponseMethodBase)methodObj));
            }
            return results;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    public Vector findProperties(String uri, String[] propNames, String depth, String type) throws WebdavException {
        Vector results = this.doPropFind(uri, null, null, null, propNames, depth, type);
        return WebdavClient.getMatchingResources(results, propNames);
    }

    public Vector findProperties(String uri, String[] propNames) throws WebdavException {
        return this.findProperties(uri, propNames, "infinity", "all");
    }

    public static String[] getPropertyNames(Vector properties) {
        Vector<String> namesList = new Vector<String>();
        for (WebdavProperty wprop : properties) {
            Enumeration<Object> en = wprop.getProperties().keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                namesList.add(key);
            }
        }
        return namesList.toArray(new String[namesList.size()]);
    }

    private static Vector storeResponseDocument(XMLResponseMethodBase methodObj) {
        Element multistatus = methodObj.getResponseDocument().getDocumentElement();
        Vector<String> names = new Vector<String>();
        Vector values = new Vector();
        Vector<Object> properties = new Vector<Object>();
        properties.add(new String[]{"Files", "Properties"});
        properties.add(names);
        properties.add(values);
        NodeList responses = multistatus.getChildNodes();
        for (int r = 0; r < responses.getLength(); ++r) {
            Node response = responses.item(r);
            NodeList responseChildren = response.getChildNodes();
            Vector propertyList = new Vector();
            Vector propNames = new Vector();
            Vector propInfo = new Vector();
            propertyList.add(propNames);
            propertyList.add(propInfo);
            for (int rc = 0; rc < responseChildren.getLength(); ++rc) {
                String name;
                Node propOrStatus;
                int p;
                Node propStat = responseChildren.item(rc);
                String propStatName = propStat.getLocalName();
                if (propStatName == null) continue;
                if (propStatName.equals("href")) {
                    names.add(propStat.getFirstChild().getNodeValue());
                    values.add(propertyList);
                    continue;
                }
                if (!propStatName.equals("propstat")) continue;
                NodeList propsOrStatii = propStat.getChildNodes();
                String statusString = "";
                for (p = 0; p < propsOrStatii.getLength(); ++p) {
                    propOrStatus = propsOrStatii.item(p);
                    name = propOrStatus.getLocalName();
                    if (name == null || !name.equals("status")) continue;
                    statusString = propOrStatus.getFirstChild().getNodeValue();
                    break;
                }
                for (p = 0; p < propsOrStatii.getLength(); ++p) {
                    propOrStatus = propsOrStatii.item(p);
                    name = propOrStatus.getLocalName();
                    if (name == null || !name.equals("prop")) continue;
                    WebdavClient.storeProperties(propOrStatus, statusString, propNames, propInfo);
                }
            }
        }
        return properties;
    }

    private static Vector getMatchingResources(Vector results, String[] propNames) {
        Vector empty = new Vector();
        if (results == null || results.size() != 6) {
            return empty;
        }
        Vector tmp = (Vector)results.get(5);
        if (tmp.size() != 3) {
            return empty;
        }
        Vector paths = (Vector)tmp.get(1);
        Vector propVect = (Vector)tmp.get(2);
        Vector<WebdavProperty> webdavProps = new Vector<WebdavProperty>();
        for (int i = 0; i < propVect.size(); ++i) {
            WebdavProperty wpr = new WebdavProperty((String)paths.get(i), (Vector)propVect.get(i));
            if (wpr == null || wpr.getProperties().size() <= 0) continue;
            webdavProps.add(wpr);
        }
        return webdavProps;
    }

    private static Vector storeLockDiscovery(Node lockDiscovery) {
        Vector lockDiscoveryList = new Vector();
        Vector<String> names = new Vector<String>();
        Vector values = new Vector();
        lockDiscoveryList.add(names);
        lockDiscoveryList.add(values);
        boolean returnEmpty = true;
        NodeList locks = lockDiscovery.getChildNodes();
        int i = 0;
        for (int l = 0; l < locks.getLength(); ++l) {
            Node lock = locks.item(l);
            String lName = lock.getLocalName();
            if (lName == null) continue;
            Vector entryProps = new Vector();
            Vector<String> entrynames = new Vector<String>();
            Vector<String> entryvalues = new Vector<String>();
            entryProps.add(entrynames);
            entryProps.add(entryvalues);
            names.add(Integer.toString(i++));
            values.add(entryProps);
            NodeList attributes = lock.getChildNodes();
            for (int a = 0; a < attributes.getLength(); ++a) {
                Node attribute = attributes.item(a);
                String aName = attribute.getLocalName();
                if (aName == null) continue;
                returnEmpty = false;
                entrynames.add(lName);
                entryvalues.add(WebdavClient.getUnknownChildValue(attribute));
            }
        }
        if (returnEmpty) {
            return new Vector();
        }
        return lockDiscoveryList;
    }

    private static Vector storeSupportedLock(Node supportedLock) {
        Vector supportedLockList = new Vector();
        Vector<Integer> names = new Vector<Integer>();
        Vector values = new Vector();
        supportedLockList.add(names);
        supportedLockList.add(values);
        boolean returnEmpty = true;
        NodeList lockEntries = supportedLock.getChildNodes();
        int i = 0;
        for (int l = 0; l < lockEntries.getLength(); ++l) {
            Node entry = lockEntries.item(l);
            String eName = entry.getLocalName();
            if (eName == null) continue;
            Vector entryProps = new Vector();
            Vector<String> entrynames = new Vector<String>();
            Vector<String> entryvalues = new Vector<String>();
            entryProps.add(entrynames);
            entryProps.add(entryvalues);
            names.add(new Integer(i++));
            values.add(entryProps);
            NodeList attributes = entry.getChildNodes();
            for (int a = 0; a < attributes.getLength(); ++a) {
                Node attribute = attributes.item(a);
                String aName = attribute.getLocalName();
                if (aName == null) continue;
                returnEmpty = false;
                entrynames.add(aName);
                entryvalues.add(WebdavClient.getUnknownChildValue(attribute));
            }
        }
        if (returnEmpty) {
            return new Vector();
        }
        return supportedLockList;
    }

    private static void storeProperties(Node prop, String status, Vector names, Vector info) {
        NodeList attributes = prop.getChildNodes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node attribute = attributes.item(a);
            String name = attribute.getLocalName();
            if (name == null) continue;
            names.add(name);
            Vector<Object> forEachName = new Vector<Object>();
            Vector<Object> values = new Vector<Object>();
            forEachName.add(new String[]{"Value", "Status"});
            forEachName.add(values);
            info.add(forEachName);
            if (name.equals("lockdiscovery")) {
                values.add(WebdavClient.storeLockDiscovery(attribute));
            } else if (name.equals("supportedlock")) {
                values.add(WebdavClient.storeSupportedLock(attribute));
            } else {
                values.add(WebdavClient.getUnknownChildValue(attribute));
            }
            values.add(status);
        }
    }

    private static String getUnknownChildValue(Node node) {
        String propValue = "";
        for (Node valueNode = node.getFirstChild(); propValue.length() == 0 && valueNode != null; valueNode = valueNode.getNextSibling()) {
            propValue = valueNode instanceof Text ? valueNode.getNodeValue().trim() : (!valueNode.hasChildNodes() ? valueNode.getLocalName() : valueNode.getFirstChild().getNodeValue());
        }
        return propValue;
    }

    public boolean doPropPatch(String uri, String responseBodyFileName, String[] requestHeaderNames, String[] requestHeaderValues, String[] propNames, String[] propValues) throws WebdavException {
        Vector results = null;
        try {
            PropPatchMethod methodObj = new PropPatchMethod(uri){

                public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
                    super.addRequestHeaders(state, conn);
                    super.setRequestHeader("Content-Length", Integer.toString(this.generateRequestBody().length()));
                }
            };
            WebdavClient.addPropertiesToSet(methodObj, propNames, propValues);
            results = this.executeMethodObject((HttpMethod)methodObj, responseBodyFileName, requestHeaderNames, requestHeaderValues);
            if (methodObj.getResponseDocument() != null && methodObj.getResponseDocument().getDocumentElement() != null) {
                results.set(results.size() - 1, WebdavClient.storeResponseDocument((XMLResponseMethodBase)methodObj));
            }
            this.currentStatusCode = methodObj.getStatusCode();
            return this.currentStatusCode == 200;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    public boolean setProperties(String uri, String[] propNames, String[] propValues) throws WebdavException {
        return this.doPropPatch(uri, null, null, null, propNames, propValues);
    }

    public boolean doPropRemove(String uri, String responseBodyFileName, String[] requestHeaderNames, String[] requestHeaderValues, String[] propNames) throws WebdavException {
        Vector results = null;
        try {
            PropPatchMethod methodObj = new PropPatchMethod(uri){

                public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
                    super.addRequestHeaders(state, conn);
                    super.setRequestHeader("Content-Length", Integer.toString(this.generateRequestBody().length()));
                }
            };
            WebdavClient.addPropertiesToRemove(methodObj, propNames);
            results = this.executeMethodObject((HttpMethod)methodObj, responseBodyFileName, requestHeaderNames, requestHeaderValues);
            if (methodObj.getResponseDocument() != null && methodObj.getResponseDocument().getDocumentElement() != null) {
                results.set(results.size() - 1, WebdavClient.storeResponseDocument((XMLResponseMethodBase)methodObj));
            }
            this.currentStatusCode = methodObj.getStatusCode();
            return this.currentStatusCode == 200;
        }
        catch (Exception e) {
            this.currentStatusCode = 420;
            throw new WebdavException(e);
        }
    }

    public boolean removeProperties(String uri, String[] propNames) throws WebdavException {
        return this.doPropRemove(uri, null, null, null, propNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector executeMethodObject(HttpMethod methodObj, String responseBodyFileName, String[] requestHeaderNames, String[] requestHeaderValues) throws FileNotFoundException, IOException {
        Vector results = null;
        WebdavClient.setRequestHeaders(methodObj, requestHeaderNames, requestHeaderValues);
        if (this.userName != null && this.password != null) {
            methodObj.setDoAuthentication(true);
        }
        try {
            this.httpClient.executeMethod(methodObj);
            results = WebdavClient.packageResults(methodObj, responseBodyFileName);
        }
        finally {
            methodObj.releaseConnection();
        }
        return results;
    }

    private static void setRequestHeaders(HttpMethod methodObj, String[] requestHeaderNames, String[] requestHeaderValues) {
        int numNames;
        if (requestHeaderNames != null && requestHeaderValues != null && (numNames = requestHeaderNames.length) > 0 && numNames == requestHeaderValues.length) {
            for (int i = 0; i < numNames; ++i) {
                methodObj.setRequestHeader(requestHeaderNames[i], requestHeaderValues[i]);
            }
        }
    }

    private static void addPropertiesToSet(PropPatchMethod methodObj, String[] propNames, String[] propValues) {
        int numNames;
        if (propNames != null && propValues != null && (numNames = propNames.length) > 0 && numNames == propValues.length) {
            for (int i = 0; i < numNames; ++i) {
                methodObj.addPropertyToSet(propNames[i], propValues[i]);
            }
        }
    }

    private static void addPropertiesToRemove(PropPatchMethod methodObj, String[] propNames) {
        int numNames;
        if (propNames != null && (numNames = propNames.length) > 0) {
            for (int i = 0; i < numNames; ++i) {
                methodObj.addPropertyToRemove(propNames[i]);
            }
        }
    }

    private static int getDepthCode(String depth) {
        int result;
        if ((depth = depth.toLowerCase()).equals("0")) {
            result = 0;
        } else if (depth.equals("1")) {
            result = 1;
        } else if (depth.equals("infinity")) {
            result = Integer.MAX_VALUE;
        } else {
            throw new RuntimeException("Depth parameter must be '0', '1', or 'infinity'.");
        }
        return result;
    }

    private static int getPropFindTypeCode(String type) {
        int result;
        if ((type = type.toLowerCase()).equals("all")) {
            result = 1;
        } else if (type.equals("names")) {
            result = 2;
        } else if (type.equals("byname")) {
            result = 0;
        } else {
            throw new RuntimeException("Scope parameter must be 'all', 'names', or 'byname'.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector packageResults(HttpMethod methodObj, String responseBodyFileName) throws IOException {
        int i;
        Vector<Object> results = new Vector<Object>(RESULT_ELEMENTS.length + 1);
        results.add(RESULT_ELEMENTS);
        Object[] statusInfo = new Object[]{new Integer(methodObj.getStatusCode()), methodObj.getStatusText()};
        results.add(statusInfo);
        Header[] headers = null;
        String[] headerStrings = null;
        int headerCount = 0;
        headers = methodObj.getRequestHeaders();
        headerCount = headers.length;
        headerStrings = new String[headerCount];
        for (i = 0; i < headerCount; ++i) {
            headerStrings[i] = headers[i].toString();
        }
        results.add(headerStrings);
        headers = methodObj.getResponseHeaders();
        headerCount = headers.length;
        headerStrings = new String[headerCount];
        for (i = 0; i < headerCount; ++i) {
            headerStrings[i] = headers[i].toString();
        }
        results.add(headerStrings);
        headers = methodObj.getResponseFooters();
        headerCount = headers.length;
        headerStrings = new String[headerCount];
        for (i = 0; i < headerCount; ++i) {
            headerStrings[i] = headers[i].toString();
        }
        results.add(headerStrings);
        String bodyStr = null;
        if (responseBodyFileName == null || responseBodyFileName.length() == 0) {
            bodyStr = methodObj.getResponseBodyAsString();
        } else {
            InputStream in = methodObj.getResponseBodyAsStream();
            FileOutputStream out = new FileOutputStream(responseBodyFileName);
            try {
                WebdavClient.transferBytes(in, out);
            }
            finally {
                in.close();
                ((OutputStream)out).close();
            }
            bodyStr = responseBodyFileName;
        }
        results.add(bodyStr);
        return results;
    }

    private static void transferBytes(InputStream sourceStream, OutputStream targetStream) throws IOException {
        int blockSize = 4096;
        byte[] buf = new byte[blockSize];
        int numRead = 0;
        while (numRead != -1) {
            numRead = sourceStream.read(buf, 0, buf.length);
            if (numRead == -1) continue;
            targetStream.write(buf, 0, numRead);
        }
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JLogger");
        System.setProperty("log4j.logger.org.apache.commons.httpclient", "error");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "error");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "error");
        RESULT_ELEMENTS = new String[]{"Status", "RequestHeaders", "ResponseHeaders", "ResponseFooters", "Body"};
    }
}

