/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.ui.model;

import com.insightful.splus.SplusDebugHandlerInterface;
import com.insightful.splus.SplusDebugListener;
import com.insightful.splus.eclipse.debug.core.SplusDebugPlugin;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugElement;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugManager;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugStackFrame;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugTarget;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugValue;
import java.util.HashMap;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class SplusWatchExpressionDelegate
implements IWatchExpressionDelegate,
SplusDebugListener {
    private static Object m_syncObject = new Object();
    private static HashMap m_evalFrames = new HashMap();
    private static HashMap m_evalTargets = new HashMap();
    private static HashMap m_evalBreaks = new HashMap();
    private static HashMap m_evalListeners = new HashMap();
    private static HashMap m_evalResults = new HashMap();

    public SplusWatchExpressionDelegate() {
        SplusDebugPlugin.getDefault().getDebugManager().addSplusDebugListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateExpression(String string, IDebugElement iDebugElement, IWatchExpressionListener iWatchExpressionListener) {
        Object object = m_syncObject;
        synchronized (object) {
            if (iDebugElement instanceof SplusDebugStackFrame) {
                SplusDebugStackFrame splusDebugStackFrame = (SplusDebugStackFrame)iDebugElement;
                String string2 = "";
                try {
                    string2 = splusDebugStackFrame.getThread().getName();
                }
                catch (DebugException debugException) {
                    debugException.printStackTrace();
                }
                Object v = m_evalFrames.get(string);
                Object v2 = m_evalBreaks.get(string);
                if (v != null && !splusDebugStackFrame.equals(v) || !splusDebugStackFrame.getThread().toString().equals(v2)) {
                    m_evalBreaks.remove(string);
                    m_evalResults.remove(string);
                    m_evalFrames.remove(string);
                    m_evalListeners.remove(string);
                    m_evalTargets.remove(string);
                } else if (m_evalResults.get(string) != null) {
                    iWatchExpressionListener.watchEvaluationFinished((IWatchExpressionResult)m_evalResults.get(string));
                }
                if (m_evalTargets.get(string) == null) {
                    SplusDebugTarget splusDebugTarget = (SplusDebugTarget)((SplusDebugElement)iDebugElement).getDebugTarget();
                    m_evalFrames.put(string, iDebugElement);
                    m_evalListeners.put(string, iWatchExpressionListener);
                    m_evalTargets.put(string, splusDebugTarget);
                    m_evalBreaks.put(string, string2);
                    SplusDebugPlugin.getDefault().getDebugManager().doEvaluate(splusDebugTarget.getExpressionID(), string);
                    return;
                }
            }
        }
    }

    public void breakpointHit(SplusDebugHandlerInterface splusDebugHandlerInterface) {
    }

    public void objectsRetrieved(SplusDebugHandlerInterface splusDebugHandlerInterface) {
    }

    public void callStackRetrieved(SplusDebugHandlerInterface splusDebugHandlerInterface) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evalInfoRetrieved(String string, SplusDebugHandlerInterface splusDebugHandlerInterface) {
        Object object = m_syncObject;
        synchronized (object) {
            if (m_evalResults.get(string) != null) {
                return;
            }
            if (m_evalListeners.get(string) != null) {
                SplusDebugManager splusDebugManager = SplusDebugPlugin.getDefault().getDebugManager();
                IWatchExpressionListener iWatchExpressionListener = (IWatchExpressionListener)m_evalListeners.get(string);
                int n = splusDebugManager.getNumEvals(string);
                SplusDebugTarget splusDebugTarget = (SplusDebugTarget)((Object)m_evalTargets.get(string));
                if (n != 0) {
                    String string2 = splusDebugManager.getEval(string, 0);
                    SplusWatchExpressionResult splusWatchExpressionResult = new SplusWatchExpressionResult(splusDebugTarget, string, string2);
                    m_evalResults.put(string, splusWatchExpressionResult);
                    iWatchExpressionListener.watchEvaluationFinished((IWatchExpressionResult)splusWatchExpressionResult);
                }
            }
        }
    }

    public class SplusDebugWatchValue
    extends SplusDebugValue {
        public SplusDebugWatchValue(SplusDebugTarget splusDebugTarget, String string, String string2) {
            super(splusDebugTarget, string, new String[]{"", "", "", "", "", string2});
        }

        public String getReferenceTypeName() throws DebugException {
            return "";
        }
    }

    public class SplusWatchExpressionResult
    implements IWatchExpressionResult {
        private SplusDebugTarget m_target;
        private String m_request;
        private String m_evalInfo;

        public SplusWatchExpressionResult(SplusDebugTarget splusDebugTarget, String string, String string2) {
            this.m_target = splusDebugTarget;
            this.m_request = string;
            this.m_evalInfo = string2;
        }

        public IValue getValue() {
            return new SplusDebugWatchValue(this.m_target, this.m_request, this.m_evalInfo);
        }

        public boolean hasErrors() {
            return this.getErrorMessages().length != 0;
        }

        public String[] getErrorMessages() {
            return new String[0];
        }

        public String getExpressionText() {
            return this.m_request;
        }

        public DebugException getException() {
            return null;
        }
    }
}

