/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.core.ECFPlugin;

public class ContainerTypeDescription {
    protected String name = null;
    protected String instantiatorClass = null;
    protected IContainerInstantiator instantiator = null;
    protected String description = null;
    protected int hashCode = 0;
    protected boolean server;
    protected boolean hidden;

    public ContainerTypeDescription(String name, String instantiatorClass, String description) {
        this(name, instantiatorClass, description, false, false);
    }

    public ContainerTypeDescription(String name, String instantiatorClass, String description, boolean server, boolean hidden) {
        Assert.isNotNull((Object)name, (String)"ContainerTypeDescription<init> name cannot be null");
        this.name = name;
        this.hashCode = name.hashCode();
        Assert.isNotNull((Object)instantiatorClass, (String)"ContainerTypeDescription<init> instantiatorClass cannot be null");
        this.instantiatorClass = instantiatorClass;
        this.description = description;
        this.server = server;
        this.hidden = hidden;
    }

    public ContainerTypeDescription(String name, IContainerInstantiator instantiator, String description) {
        this(name, instantiator, description, false, false);
    }

    public ContainerTypeDescription(String name, IContainerInstantiator inst, String desc, boolean server, boolean hidden) {
        Assert.isNotNull((Object)name, (String)"ContainerTypeDescription<init> name cannot be null");
        this.name = name;
        this.hashCode = name.hashCode();
        Assert.isNotNull((Object)inst, (String)"ContainerTypeDescription<init> instantiator instance cannot be null");
        this.instantiator = inst;
        this.description = desc;
        this.server = server;
        this.hidden = hidden;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ContainerTypeDescription)) {
            return false;
        }
        ContainerTypeDescription scd = (ContainerTypeDescription)other;
        return scd.name.equals(this.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("ContainerTypeDescription[");
        b.append("name=").append(this.name).append(";");
        if (this.instantiator == null) {
            b.append("instantiatorClass=").append(this.instantiatorClass).append(";");
        } else {
            b.append("instantiator=").append(this.instantiator).append(";");
        }
        b.append("desc=").append(this.description).append(";");
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IContainerInstantiator getInstantiator() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ContainerTypeDescription containerTypeDescription = this;
        synchronized (containerTypeDescription) {
            if (this.instantiator == null) {
                this.initializeInstantiator();
            }
            return this.instantiator;
        }
    }

    private void initializeInstantiator() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(this.instantiatorClass);
        this.instantiator = (IContainerInstantiator)clazz.newInstance();
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String[] getSupportedAdapterTypes() {
        String method = "getSupportedAdapterTypes";
        Trace.entering((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/entering", this.getClass(), (String)method);
        String[] result = new String[]{};
        try {
            String[] r = this.getInstantiator().getSupportedAdapterTypes(this);
            if (r != null) {
                result = r;
            }
        }
        catch (Exception e) {
            this.traceAndLogException(4, method, e);
        }
        Trace.exiting((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/exiting", this.getClass(), (String)method, (Object)result);
        return result;
    }

    protected void traceAndLogException(int code, String method, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/exceptions/catching", this.getClass(), (String)method, (Throwable)e);
        ECFPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf", code, method, e));
    }

    public Class[][] getSupportedParameterTypes() {
        String method = "getParameterTypes";
        Trace.entering((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/entering", this.getClass(), (String)method);
        Class[][] result = new Class[0][0];
        try {
            Class[][] r = this.getInstantiator().getSupportedParameterTypes(this);
            if (r != null) {
                result = r;
            }
        }
        catch (Exception e) {
            this.traceAndLogException(4, method, e);
        }
        Trace.exiting((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/exiting", this.getClass(), (String)method, (Object)result);
        return result;
    }
}

