/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: device.h,v $: $Revision: #12 $, $Date: 2007/03/21 $  */

#ifndef _S_DEVICE_H_ /*(*/
#define _S_DEVICE_H_

#define NPRIMITIVES 30
#include "displist.h"
typedef s_object *(*qpe_fun_ptr) ();
typedef struct s_device {
	int active;
	long which;	/* index in the list of devices: see $M/device.c */
	DisplayListHead *displaylist ;
	float *params;
	long nlocal;
	char *local_params;
	qpe_fun_ptr routines[NPRIMITIVES];
} device;

#include "libext.h"

LibExtern void S_STDCALL S_device_status(void) ;
LibExtern void S_STDCALL S_next_device(long *which) ;
LibExtern void S_STDCALL S_prev_device(long *which) ;
LibExtern void S_STDCALL S_current_device(long *which) ;
LibExtern void S_STDCALL S_set_device(long *which) ;
LibExtern void S_STDCALL S_shutdown_device(long *which) ;
LibExtern void S_STDCALL gr_wrap(void) ;

LibExtern void S_STDCALL set_device(long which) ; /* defined in device.c */
LibExtern long S_STDCALL S_swap_device(long which) ;
LibExtern int S_STDCALL S_request_device_change(long *which) ;
LibExtern void S_STDCALL S_schedule_action(void) ;

/* defines for routine position in dev->routines */
#define DEV_initial 0
#define DEV_wrap 1
#define DEV_flush 2
#define DEV_signalled 3
#define DEV_marks 4
#define DEV_lines 5
#define DEV_polygon 6
#define DEV_text 7
#define DEV_segments 8
#define DEV_clear 9
#define DEV_input 10
#define DEV_menu 11
#define DEV_hook 12
#define DEV_seek 13
#define DEV_ptchar 14
#define DEV_line 15
#define DEV_length 16
#define DEV_query 17
#define DEV_image 18
#define DEV_printgraph 19
#define DEV_redraw 20
#define DEV_brush 21
#define DEV_spin 22
#define DEV_switchmode 23
#define DEV_activate 24
#define DEV_axis 25
#define DEV_image_rgba 26

LibExtern device *cur_device;
LibExtern device deflt_device;
LibExtern device* S_STDCALL get_devicep(long which) ;

#define NPARAMS 200

#define NULL_DEVICE (&deflt_device)

#define TTY5620 -999
#define POSTSCRIPT -998
#define HPGL -997
#define PRINTER -996
#define TEK4014 -995
#define TTY630 -994
#define TEK4105 -993
#define HP2623	-991
#define HP2648	-990
#define HP2628	-990
#define HP2627	-989
#define HP150	-988
#define X11	-1111
#define NEWS	-987
#define SUN -425
#define MSWIN3X	-986
#define MSWIN3XPRN -985

/* hook types */
#define HOOK_setcolor		1	/* set the color table */
#define HOOK_getcolor		2	/* get the color table */
LibExtern int image_start_color, image_last_color, image_color_offset;

#define DEV_CHG_REQU_QUEUED		0
#define DEV_CHG_REQU_NO_SUCH_DEVICE	1
#define DEV_CHG_REQU_ALREADY_CURRENT	2
#define DEV_CHG_REQU_QUEUE_FULL		3

#include "unlibext.h"
#endif /* !_S_DEVICE_H_ )*/
