/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: io_defs.h,v $: $Revision: #7 $, $Date: 2006/06/26 $  */
#ifndef IO_DEFS_H
#define IO_DEFS_H

#include "S_struct.h"

/* a type for the parameters stored in the connection structure */
typedef long CONNECTION_PARAMETER;
enum connect_error {CONNECTION_CLOSE, CONNECTION_IGNORE};
enum prompt_state {READY_FOR_PROMPT, PROMPTED, NEVER_PROMPT};
/* structure to hold connection objects internally */
/* This currently has two interpretations.  For files and pipes, the */
/* mode element is the read/write mode and pid is the (pipe) process */
/* id.  For sockets, pid is the port number */
struct s_connection_struct {
	char *description;
	CONNECTION_PARAMETER rfd;	/*YB: rfd on WIN32 should be a handle */
	CONNECTION_PARAMETER wfd;
	FILE *rfile;
	FILE *wfile;
	CONNECTION_PARAMETER mode;
	CONNECTION_PARAMETER pid;
	s_class *type;
	enum connect_error error_action;
	s_name *posix_mode;
	int rtag;
	int wtag;
	int cur_mode;
	fpos_t rpos;
	fpos_t wpos;
	char *put_back;
	char *put_back_ptr;
	int put_back_len;
	int put_back_max;
	enum prompt_state prompt;
	struct stat *sbuf;
	unsigned char wait_on_input;
	int incomplete; /* >0 if last read/write got EAGAIN*/
};

typedef struct s_connection_struct s_connection;


/* standard connections input, output, message and struct to push down previous settings*/
struct connection_save_struct {
  s_connection *con;
  s_boolean opened_here;
  struct connection_save_struct *next;
};

typedef struct connection_save_struct connection_save;


#define N_STANDARD_STREAMS 3
#define S_NOT_A_DB -3
#define S_ANY_DATABASE -2
#define S_SYS_DATABASE -4

#endif
