/*
* notifyc.h : header file for the engine codes to notify the clients.
*/

#ifndef S_NOTIFY_CLIENT_H
#define S_NOTIFY_CLIENT_H

#include "S.h"
#include "libext.h"
S_begin_extern_c

/* Define macros for messages */
#define S_MSG_EXCEPTION -1
#define S_MSG_MODIFY     1
#define S_MSG_REMOVE     2
#define S_MSG_ATTACH     3
#define S_MSG_DETACH     4
#define S_MSG_TEXTOUT    5
#define S_MSG_PREMODIFY  6
#define S_MSG_UNCACHED   7
#define S_MSG_SETOPT     8

/* Define macros for S_MSG_TEXTOUT flags */
#define S_MSG_TEXTOUT_IMMEDSTDERR	(1 << 0)

/* Define macros for GUI-bound messages */
#define S_MSG_SENDBASE				500

#define S_MSG_QUERYBASE				500
#define S_MSG_GETAPPNAME			(S_MSG_QUERYBASE+0)
#define S_MSG_GETCONFIGINFO			(S_MSG_QUERYBASE+1)
#define S_MSG_GETPAGESIZE			(S_MSG_QUERYBASE+2)
#define S_MSG_PARSETEST				(S_MSG_QUERYBASE+3)
#define S_MSG_ISATTY				(S_MSG_QUERYBASE+4)
#define S_MSG_ISINMAINMENU			(S_MSG_QUERYBASE+5)
#define S_MSG_ISINSTARTUPCODE		(S_MSG_QUERYBASE+6)
#define S_MSG_QUERYLAST				509

#define S_MSG_CMDHISTBASE			510
#define S_MSG_CMDHIST_FIND			(S_MSG_CMDHISTBASE+0)
#define S_MSG_CMDHIST_GETLINE		(S_MSG_CMDHISTBASE+1)
#define S_MSG_CMDHIST_FILENAME		(S_MSG_CMDHISTBASE+2)
#define S_MSG_CMDHIST_PROMPT		(S_MSG_CMDHISTBASE+3)
#define S_MSG_CMDHISTLAST			519

#define S_MSG_PSEUDOPROCBASE		520
#define S_MSG_PSEUDOPROC_OPEN		(S_MSG_PSEUDOPROCBASE+0)
#define S_MSG_PSEUDOPROC_ISOPEN		(S_MSG_PSEUDOPROCBASE+1)
#define S_MSG_PSEUDOPROCLAST		529

#define S_MSG_EVALINPUTBASE			530
#define S_MSG_EVALINPUT_GET			(S_MSG_EVALINPUTBASE+0)
#define S_MSG_EVALINPUT_PEEK		(S_MSG_EVALINPUTBASE+1)
#define S_MSG_EVALINPUT_END			(S_MSG_EVALINPUTBASE+2)
#define S_MSG_EVALINPUTLAST			539

#define S_MSG_HELPBASE				540
#define S_MSG_HELP_DISPLAY			(S_MSG_HELPBASE+0)
#define S_MSG_HELP_QUERY			(S_MSG_HELPBASE+1)
#define S_MSG_HELP_UPDATEIDLIST		(S_MSG_HELPBASE+2)
#define S_MSG_HELPLAST				549

/* Define macros for graphics messages */
#define S_MSG_GRBASE				600
#define S_MSG_GR_UPDATE				(S_MSG_GRBASE+0)
#define S_MSG_GR_INITIAL			(S_MSG_GRBASE+1)
#define S_MSG_GR_WRAP				(S_MSG_GRBASE+2)
#define S_MSG_GR_FLUSH				(S_MSG_GRBASE+3)
#define S_MSG_GR_SIGNALLED			(S_MSG_GRBASE+4)
#define S_MSG_GR_MARKS				(S_MSG_GRBASE+5)
#define S_MSG_GR_LINES				(S_MSG_GRBASE+6)
#define S_MSG_GR_POLYGON			(S_MSG_GRBASE+7)
#define S_MSG_GR_TEXT				(S_MSG_GRBASE+8)
#define S_MSG_GR_SEGMENTS			(S_MSG_GRBASE+9)
#define S_MSG_GR_CLEAR				(S_MSG_GRBASE+10)
#define S_MSG_GR_INPUT				(S_MSG_GRBASE+11)
#define S_MSG_GR_MENU				(S_MSG_GRBASE+12)
#define S_MSG_GR_HOOK				(S_MSG_GRBASE+13)
#define S_MSG_GR_SEEK				(S_MSG_GRBASE+14)
#define S_MSG_GR_PTCHAR				(S_MSG_GRBASE+15)
#define S_MSG_GR_LINE				(S_MSG_GRBASE+16)
#define S_MSG_GR_LENGTH				(S_MSG_GRBASE+17)
#define S_MSG_GR_QUERY				(S_MSG_GRBASE+18)
#define S_MSG_GR_IMAGE				(S_MSG_GRBASE+19)
#define S_MSG_GR_PRINTGRAPH			(S_MSG_GRBASE+20)
#define S_MSG_GR_REDRAW				(S_MSG_GRBASE+21)
#define S_MSG_GR_BRUSH				(S_MSG_GRBASE+22)
#define S_MSG_GR_SPIN				(S_MSG_GRBASE+23)
#define S_MSG_GR_SWITCHMODE			(S_MSG_GRBASE+24)
#define S_MSG_GR_ACTIVATE			(S_MSG_GRBASE+25)
#define S_MSG_GR_AXIS				(S_MSG_GRBASE+26)

#define S_MSG_GR_IMAGERGBA			(S_MSG_GRBASE+27)

#define S_MSG_GRLAST				699

#define S_MSG_APPSPECIALBASE		1000

#define S_MSG_MSGBOX				(S_MSG_APPSPECIALBASE+0)
#define S_MSG_GUIQ					(S_MSG_APPSPECIALBASE+1)
#define S_MSG_GUILOCK				(S_MSG_APPSPECIALBASE+2)

#define S_MSG_V33GUIBASE			(S_MSG_APPSPECIALBASE+20)
#define S_MSG_GETMENU				(S_MSG_V33GUIBASE+0)
#define S_MSG_SETMENU				(S_MSG_V33GUIBASE+1)
#define S_MSG_MENULENGTH			(S_MSG_V33GUIBASE+2)
#define S_MSG_MENUITEMTYPE			(S_MSG_V33GUIBASE+3)
#define S_MSG_GETMENUITEM			(S_MSG_V33GUIBASE+4)
#define S_MSG_LOCATEMENUITEM		(S_MSG_V33GUIBASE+5)
#define S_MSG_CALLMENUITEM			(S_MSG_V33GUIBASE+6)
#define S_MSG_UPDATEMENUITEM		(S_MSG_V33GUIBASE+7)
#define S_MSG_MOVEMENUITEM			(S_MSG_V33GUIBASE+8)
#define S_MSG_INITDYNDLG			(S_MSG_V33GUIBASE+9)
#define S_MSG_RUNDYNDLG				(S_MSG_V33GUIBASE+10)
#define S_MSG_SIMULATEKEYS			(S_MSG_V33GUIBASE+11)
#define S_MSG_FREEOBJ				(S_MSG_V33GUIBASE+12)
#define S_MSG_V33GUILAST			(S_MSG_APPSPECIALBASE+49)

#define S_MSG_OLEBASE				(S_MSG_APPSPECIALBASE+50)
#define S_MSG_OLE_CREATEOBJ			(S_MSG_OLEBASE+0)
#define S_MSG_OLE_RELEASEOBJ		(S_MSG_OLEBASE+1)
#define S_MSG_OLE_ADDREF			(S_MSG_OLEBASE+2)
#define S_MSG_OLE_REFCOUNT			(S_MSG_OLEBASE+3)
#define S_MSG_OLE_CALLMETHOD		(S_MSG_OLEBASE+4)
#define S_MSG_OLE_GETPROP			(S_MSG_OLEBASE+5)
#define S_MSG_OLE_SETPROP			(S_MSG_OLEBASE+6)
#define S_MSG_OLE_ISOBJVALID		(S_MSG_OLEBASE+7)
#define S_MSG_OLE_REGISTEROBJ		(S_MSG_OLEBASE+8)
#define S_MSG_OLE_UNREGISTEROBJ		(S_MSG_OLEBASE+9)
#define S_MSG_OLE_REGISTERALL		(S_MSG_OLEBASE+10)
#define S_MSG_OLE_UNREGISTERALL		(S_MSG_OLEBASE+11)
#define S_MSG_OLE_REBUILDTYPELIB	(S_MSG_OLEBASE+12)
#define S_MSG_OLE_DESTROYTYPELIB	(S_MSG_OLEBASE+13)
#define S_MSG_OLE_REBUILDHTMLLIB	(S_MSG_OLEBASE+14)
#define S_MSG_OLELAST				(S_MSG_APPSPECIALBASE+99)

#define S_MSG_APPSPECIALLAST		1499

#define S_MSG_SENDLAST				1499

/*
//TODO: merge SNotifyClient with S_EngineMessage
*/
LibExtern void S_STDCALL SNotifyClient(
	const char* pszName,            /* Obj name */
	long lMsg,                      /* Message Id */
	s_object* pSOldPermObject,      /* Old object pointer */
	s_object* pSNewPermObject,      /* New object pointer */
	long lTargetDBIndex             /* DB index */
	);

/*
//Engine message sending to the client
*/
LibExtern long S_STDCALL S_SendClientMessage(
	long lMsg,        /* message Id */
	long lArgs,       /* number of args */
	void** ppArgs     /* content depends on lMsg with length lArgs */
);

LibExtern long S_CDECL S_SendClientMessageVargs(
	long lMsg,		/* message Id */
	long lArgs,		/* number of args */
	...				/* content depends on lMsg with length lArgs */
);

S_end_extern_c
#include "unlibext.h"

#endif /* S_NOTIFY_CLIENT_H */
