/**************************************************************************/
#if !defined(_IM_NEURAL_NETWORK_H_)
#define _IM_NEURAL_NETWORK_H_

#include "IMObjects.h"

#define IMinerNeuralNetworkModel IMinerObject

#define IMINER_NNET_META_DATA_NUM 0
#define IMINER_NNET_TYPE_NUM      1
#define IMINER_NNET_NUMERIC_NUM   2
#define IMINER_NNET_RANGE_NUM     3
#define IMINER_NNET_INPUT_NUM     4
#define IMINER_NNET_DEP_LEVELS    5
#define IMINER_NNET_OUTPUT	      6
#define IMINER_NNET_HIDDEN_NUM    7
#define IMINER_NNET_NON_HIDDEN	  7


/* macro to access a matrix element from IMinerMatrix object*/
#define IMINER_NNET_GET_LAYERS(model)		(model)->m_nLen-IMINER_NNET_NON_HIDDEN+1
#define IMINER_NNET_WEIGHTS_PTR(pObj, i)	(pObj)->m_uData.m_ppList[i]
#define IMINER_NNET_META_DATA(model)		IMINER_NNET_WEIGHTS_PTR(model, IMINER_NNET_META_DATA_NUM)
#define IMINER_NNET_TYPE(model)			    IMINER_NNET_WEIGHTS_PTR(model, IMINER_NNET_TYPE_NUM)
#define IMINER_NNET_NUMERIC(model)			IMINER_NNET_WEIGHTS_PTR(model, IMINER_NNET_NUMERIC_NUM)
#define IMINER_NNET_RANGE(model)			IMINER_NNET_WEIGHTS_PTR(model, IMINER_NNET_RANGE_NUM)
#define IMINER_NNET_INPUT(model)			IMINER_NNET_WEIGHTS_PTR(model, IMINER_NNET_INPUT_NUM)
#define IMINER_NNET_OUTPUT_PTR(model)		IMINER_NNET_WEIGHTS_PTR(model, IMINER_NNET_OUTPUT)
#define IMINER_NNET_DEP_LEVELS_PTR(model)	IMINER_NNET_WEIGHTS_PTR(model, IMINER_NNET_DEP_LEVELS)
#define IMINER_NNET_HIDDEN(model, i)		IMINER_NNET_WEIGHTS_PTR(model, i+IMINER_NNET_HIDDEN_NUM)

#ifdef __cplusplus
extern "C" {
#endif

/* alloc memory and set content for class KMeans Cluster */
IMCSRC_DLLAPI(long) IMinerNeuralNetworkModel_create(
 IMinerObject* pModel,		    /* out: data object */
 IMinerObject* md,			    /* in:  meta data object */
 long nInputs,                  /* in:  number of input nodes */
 long nOutputs,                 /* in:  number of output nodes */
 long nHiddenLayers,            /* in:  number of hidden layers */ 
 long nNodesPerLayer,           /* in:  number of nodes per layer */ 
 long bClassification,			/* in:  is model classification? */
 const long* pnNumericColumn,   /* in:  stores whether a column is numeric of length (nInputs) */
 const double* pdRangeVals,     /* in:  min & max value of inputs and then dependent variables */
 const double* pdInputWeights,  /* in:  input weights of length [(nInputs+1)*(nNodesPerLayer)] */
 const double* pdHiddenWeights, /* in:  scaling factors of length [(nNodesPerLayer+1)*(nNodesPerLayer)]*(nHiddenLayers-1) */
 const double* pdOutputWeights, /* in:  loading factors of length [(nNodesPerLayer+1)*(nOutputs)] */
 const char **pcDepLevels		/* in:  dependent levels if categorical (nOutputs) */
);

/* validate the object */
IMCSRC_DLLAPI(long) IMinerNeuralNetworkModel_isValid(const IMinerObject* pModel);

/* free memory */
IMCSRC_DLLAPI(long) IMinerNeuralNetworkModel_destroy(IMinerObject* pModel );

/* write to stdout */
IMCSRC_DLLAPI(long) IMinerNeuralNetworkModel_print(const IMinerObject* pModel);

/* predict cluster memberships */
IMCSRC_DLLAPI(long) IMinerNeuralNetworkModel_predict(
 IMinerObject* pOutput,      /* out: output rectangular data */
 const IMinerObject* pInput, /* in: input rectangular data */
 IMinerObject* pDescr,		 /* in: input description (if NULL, description will be 
                                    created from input data) */
 const IMinerObject* pModel  /* in: the model */
);

#ifdef __cplusplus
}
#endif

#endif /*_IM_NEURAL_NETWORK_H_ */

