map.cities <- function(state="Washington",var="Pop1990"){

###########################################################################
###
### map.cities: Produces a graphlet map of cities within a single State.
###              
###             
### Arguments:
###
### State:     State to plot
###
### vartoplot: Not currently used!
###
###########################################################################


  ## Clean up the state string (remove any "%20" characters).
  state <- token(source=state)
  
  ##  Subset cities dataframe down to the selected State.
  idx <- as.character(cities$State.name) == state
  c.in.s <- cities[idx,]

  ## Set the color scheme for the graphics device
  java.set.colorscheme(java.colorscheme.trellis)


  ## plot a map of the selected state
  map("state", regions=state, resolution=0)

  ## Allow further plots to overlay the current graph
  par(new=T)

  ##Add the county boundaries to the plot
  map("county", regions=state)


  ##Add the cities as points
  points(c.in.s$X,c.in.s$Y, pch=16, col=8)


  ## Define action areas and commands to run when selected by the user.
  java.identify(c.in.s$X, c.in.s$Y, labels=c.in.s$City.name,
		actions = paste(
		  '<menu title="', 'Cities For 1 State', '">',
		  '<menuitem label="Histogram of Populations">',
		  MakeAction(hist.cities,state=state,city=as.character(c.in.s$City.name)),
		  '</menuitem>',
		  '</menu>'))
}

