////////////////////////////////////////////////////////////////////////////
// euler.h : main header file for EULER.DLL
// See euler.cxx for implementation.
// See euler.ssc for implementation of the corresponding S function.
//
// EULER_DLL_API assists exporting/importing functions defined in EULER.DLL.
// It is for exporting if this header file is included in the source file (.c/.cxx) 
// that defines these functions, else importing.
//
// Symbols are exported if SP_CHAPTER_EULER is defined, else imported.
// SP_CHAPTER_EULER is automatically defined by the SPLUS Chapter Wizard. 
// Look at the setting..., C/C++ tap. 
////////////////////////////////////////////////////////////////////////////

#undef EULER_DLL_API
#if defined(WIN32) && defined(SP_CHAPTER_EULER)
	#define EULER_DLL_API(returnType) __declspec(dllexport) returnType __stdcall
#elif defined(WIN32)
	#define EULER_DLL_API(returnType) __declspec(dllimport) returnType __stdcall
#else
	#define EULER_DLL_API(returnType) returnType
#endif

#ifdef __cplusplus
extern "C" {
#endif

EULER_DLL_API(s_object* ) euler(s_object* , s_object* , s_object*, s_object*, s_object* );

#ifdef __cplusplus
}
#endif

