/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

#ifdef WIN32

#include "windows.h"
#include "oleauto.h"
#include <comdef.h>
#include "sconnect_com.h"
#include "sconnect_gen.h"
#include "spchar.h"
#include "spint.h"
#include "splist.h"
#include "splog.h"
#include "spmatrix.h"
#include "spnum.h"
#include "spolecli.h"
#include "spexcept.h"
#include "spvariant.h"

// Avoid having to include slocal/import/src/sttrans.h (CRD)
extern "C" s_object *time_to_datenum( s_object *time_vec, int excel );
extern "C" s_object *time_from_datenum( s_object *num_vec, int excel );

static s_object *time_from_datenum_automation( s_object *num_vec )
{
	s_object *ps_timedate = NULL;
	try
	{
		if( !S_evaluator->_eval_open )
			SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);

//		BOOL bNoTime = TRUE;
//		long length = GET_LENGTH(num_vec);
//		double *pdData = NUMERIC_POINTER( num_vec );
//		for ( long i=0; i<length; i++ )
//		{
//			double dValue = pdData[i];
//			if (is_na_DOUBLE&dValue))
//				continue;
//			long lJulian = (long)floor(dValue);
//			double frac = dValue-lJulian;
//			if ( frac != 0 )
//			{
//				bNoTime = FALSE;
//				break;
//			}
//		}
		BOOL bNoTime = FALSE;

		ps_timedate = time_from_datenum( num_vec, 0 );
		if ( SPL_NotThere( ps_timedate ) )
	 		SCONNECT_ThrowException("time_from_numeric() failed");
		long indexTimeOutFmtSlot = get_slot_offset(MAKE_CLASS("timeDate"), "format", S_evaluator);
		if ( indexTimeOutFmtSlot < 0 )
			SCONNECT_ThrowException("invalid format slot");
		s_object* ps_format = NEW_CHARACTER(1);
		char **ppsz = CHARACTER_POINTER( ps_format );

		s_object *ps_options = find_data(make_name(".Options", S_evaluator), S_TRUE, S_FALSE, S_evaluator);
		if ( SPL_NotThere( ps_options ) )
			SCONNECT_ThrowException("invalid .Options object");
		long n = x_which_comp("time.out.format", ps_options, S_evaluator)-1;
		if ( bNoTime )
			n = x_which_comp("time.out.format.notime", ps_options, S_evaluator)-1;
		char *pszTimeOutFmt = CHARACTER_VALUE(LIST_POINTER(ps_options)[n]);
		if ( pszTimeOutFmt != NULL )
		{
			ppsz[0] = c_s_cpy( pszTimeOutFmt, S_evaluator);
			CHARACTER_POINTER( ps_format ) = ppsz;
			SET_ELEMENT( ps_timedate, indexTimeOutFmtSlot, ps_format ); 
		}
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	return ps_timedate;
}

#define	S_DATE_OFFSET 21916 // used in writing dates to the engine

static s_object * SPL_GenerateFromVptr( long sMode, long rows, long cols, long nElemSize, void *pvData, BOOL b2dAsDataFrame )
{
	s_object * ps_object = NULL;
	if ( sMode == S_MODE_NULL )
		return ps_object;
	if ( rows <= 0 || cols <= 0 )
		return ps_object;
	if ( nElemSize <= 0 )
		return ps_object;
	if ( !pvData )
		return ps_object;

	try
	{
		if( !S_evaluator->_eval_open )
			SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);

		if ( cols > 1 )
		{
			CSPlist tmpList(cols);
			CSPobject spObj;

			for ( int i=0; i<cols; i++ )
			{
				s_object *ps_elem = SPL_GenerateVectorFromDataArray( sMode, rows, (char *)pvData+(i*rows*nElemSize) );
				tmpList.SetAtDirect( i, ps_elem );
			}

			if (b2dAsDataFrame)
			{
				CSPcall call1("as.data.frame");
				call1.SetArg(tmpList, 1);
				spObj = call1.Eval();
				ps_object = spObj.ClonePermanent();
			}
			else
			{
				ps_object = tmpList.Detach();
			}
		}
		else
		{
			ps_object = SPL_GenerateVectorFromDataArray( sMode, rows, pvData );
		}
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	return ps_object;
}

static s_object * SPL_GenerateFromBSTR( long rows, long cols, void *pvData, BOOL b2dAsDataFrame )
{
	s_object * ps_object = NULL;
	if ( rows <= 0 || cols <= 0 )
		return ps_object;

	try
	{
		if( !S_evaluator->_eval_open )
			SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);

		if ( cols > 1 )
		{
			CSPlist tmpList(cols);
			CSPobject spObj;

			for ( int i=0; i<cols; i++ )
			{
				CSPcharacter tmpVec(rows);
				if ( pvData )
				{
					for ( int j=0; j<rows; j++ )
					{
						BSTR bstrItem = ((BSTR *)(pvData))[(i*rows)+j];
						_bstr_t bstrTMP( bstrItem );
						char *pszElem = (char*) S_alloc(bstrTMP.length()+ 1, sizeof(char), S_evaluator);
						strcpy(pszElem, (char *)bstrTMP);

						tmpVec.SetAtDirect( j, pszElem, FALSE, FALSE );
					}
					tmpVec.MakeStringsRemovable(FALSE);
				}
				tmpList.SetAtDirect( i, tmpVec.Detach() );
			}
			ps_object = tmpList.Detach();

			if (b2dAsDataFrame)
			{
				CSPcall call1("as.data.frame");
				call1.SetArg(ps_object, 1);
				spObj = call1.Eval();
				ps_object = spObj.ClonePermanent();
			}
		}
		else
		{
			CSPcharacter tmpVec(rows);
			if ( pvData )
			{
				for ( int j=0; j<rows; j++ )
				{
					BSTR bstrItem = ((BSTR *)(pvData))[j];
					_bstr_t bstrTMP( bstrItem );
					char *pszElem = (char*) S_alloc(bstrTMP.length()+ 1, sizeof(char), S_evaluator);
					strcpy(pszElem, (char *)bstrTMP);
					tmpVec.SetAtDirect( j, pszElem, FALSE, FALSE );
				}
				tmpVec.MakeStringsRemovable(FALSE);
			}
			ps_object = tmpVec.Detach();
		}
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	return ps_object;
}

static s_object * SPL_GenerateFromSHORT( long rows, long cols, void *pvData, BOOL b2dAsDataFrame )
{
	s_object * ps_object = NULL;
	if ( rows <= 0 || cols <= 0 )
		return ps_object;
	if ( !pvData )
		return ps_object;

	try
	{
		if( !S_evaluator->_eval_open )
			SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);

		if ( cols > 1 )
		{
			CSPlist tmpList(cols);
			CSPobject spObj;

			for ( int i=0; i<cols; i++ )
			{
				s_object *ps_elem = SPL_GenerateVectorFromDataArray( S_MODE_INT, rows, (short *)pvData+(i*rows) );
				tmpList.SetAtDirect( i, ps_elem );
			}
			ps_object = tmpList.Detach();

			if (b2dAsDataFrame)
			{
				CSPcall call1("as.data.frame");
				call1.SetArg(ps_object, 1);
				spObj = call1.Eval();
				ps_object = spObj.ClonePermanent();
			}
		}
		else
		{
			ps_object = SPL_GenerateVectorFromDataArray( S_MODE_INT, rows, (short *)pvData );
		}
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	return ps_object;
}

static s_object * SPL_GenerateFromFLOAT( long rows, long cols, void *pvData, BOOL b2dAsDataFrame )
{
	s_object * ps_object = NULL;
	if ( rows <= 0 || cols <= 0 )
		return ps_object;
	if ( !pvData )
		return ps_object;

	try
	{
		if( !S_evaluator->_eval_open )
			SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);

		if ( cols > 1 )
		{
			CSPlist tmpList( cols );
			CSPobject spObj;

			for ( int i=0; i<cols; i++ )
			{
				s_object *ps_elem = SPL_GenerateVectorFromDataArray( S_MODE_REAL, rows, (float *)pvData+(i*rows) );
				tmpList.SetAtDirect( i, ps_elem );
			}
			ps_object = tmpList.Detach();

			if (b2dAsDataFrame)
			{
				CSPcall call1("as.data.frame");
				call1.SetArg(ps_object, 1);
				spObj = call1.Eval();
				ps_object = spObj.ClonePermanent();
			}
		}
		else
		{
			ps_object = SPL_GenerateVectorFromDataArray( S_MODE_REAL, rows, (float *)pvData );
		}
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	return ps_object;
}

static s_object * SPL_GenerateFromDATE( long rows, long cols, void *pvData, BOOL b2dAsDataFrame )
{
	s_object * ps_object = NULL;
	if ( rows <= 0 || cols <= 0 )
		return ps_object;
	if ( !pvData )
		return ps_object;

	try
	{
		if( !S_evaluator->_eval_open )
			SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);

		if ( cols > 1 )
		{
			CSPlist tmpList(cols);
			CSPobject spObj;

			for ( int i=0; i<cols; i++ )
			{
				s_object *ps_elem = SPL_GenerateVectorFromDataArray( S_MODE_DOUBLE, rows, (double *)pvData+(i*rows) );
				tmpList.SetAtDirect( i, time_from_datenum_automation( ps_elem ) );
			}
			ps_object = tmpList.Detach();

			if (b2dAsDataFrame)
			{
				CSPcall call1("as.data.frame");
				call1.SetArg(ps_object, 1);
				spObj = call1.Eval();
				ps_object = spObj.ClonePermanent();
			}
		}
		else
		{
			s_object *ps_elem = SPL_GenerateVectorFromDataArray( S_MODE_DOUBLE, rows, (double *)pvData );
			ps_object = time_from_datenum_automation( ps_elem );
		}
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	return ps_object;
}

static s_object * SPL_GenerateFromCURRENCY( long rows, long cols, void *pvData, BOOL b2dAsDataFrame )
{
	s_object * ps_object = NULL;
	if ( rows <= 0 || cols <= 0 )
		return ps_object;
	if ( !pvData )
		return ps_object;

	try
	{
		if( !S_evaluator->_eval_open )
			SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);

		if ( cols > 1 )
		{
			CSPlist tmpList( cols );
			CSPobject spObj;

			for ( int i=0; i<cols; i++ )
			{
				CY* cyVal = (((CY*)pvData)+(i*rows));
				double dblVal = 0;
				if(VarR8FromCy(*cyVal, &dblVal) == S_OK)
				{
					s_object *ps_elem = SPL_GenerateVectorFromDataArray( S_MODE_DOUBLE, rows, &dblVal );
					tmpList.SetAtDirect( i, ps_elem );
				}
			}
			ps_object = tmpList.Detach();

			if (b2dAsDataFrame)
			{
				CSPcall call1("as.data.frame");
				call1.SetArg(ps_object, 1);
				spObj = call1.Eval();
				ps_object = spObj.ClonePermanent();
			}

		}
		else
		{
			CY* cyVal = (CY*)pvData;
			double dblVal = 0;
			if(VarR8FromCy(*cyVal, &dblVal) == S_OK)
			{
				ps_object = SPL_GenerateVectorFromDataArray( S_MODE_DOUBLE, rows, &dblVal );
			}
		}
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	return ps_object;
}

static s_object * SPL_GenerateFromDISPATCH( long rows, long cols, void *pvData, BOOL b2dAsDataFrame )
{
	s_object * ps_object = NULL;
	if ( rows <= 0 || cols <= 0 )
		return ps_object;
	if ( !pvData )
		return ps_object;

	try
	{
		if( !S_evaluator->_eval_open )
			SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);

		if ( cols > 1 )
		{
			if ( !b2dAsDataFrame )
			{
				CSPlist tmpList(cols);
				for ( int i=0; i<cols; i++ )
				{
					if ( rows > 1 )
					{
						CSPlist tmpListCol(rows);
						for( int j=0; j<rows; j++ )
						{
							LPDISPATCH lpDispatch = ((LPDISPATCH *)pvData)[i*rows+j];
							CSPoleclient tmpClient( lpDispatch );
							tmpListCol.SetAtDirect( j, tmpClient );
						}
						tmpList.SetAtDirect( i, tmpListCol );
					}
					else
					{
						LPDISPATCH lpDispatch = ((LPDISPATCH *)pvData)[i];
						CSPoleclient tmpClient( lpDispatch );
						tmpList.SetAtDirect( i, tmpClient );
					}
				}
				ps_object = tmpList.Detach();
			}
		}
		else
		{
			if ( rows > 1 )
			{
				CSPlist tmpList(rows);
				for( int i=0; i<rows; i++ )
				{
					LPDISPATCH lpDispatch = ((LPDISPATCH *)pvData)[i];
					CSPoleclient tmpClient( lpDispatch );
					tmpList.SetAtDirect( i, tmpClient );
				}
				ps_object = tmpList.Detach();
			}
			else
			{
				LPDISPATCH lpDispatch = ((LPDISPATCH *)pvData)[0];
				CSPoleclient tmpClient( lpDispatch );
				ps_object = tmpClient.Detach();
			}
		}
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	return ps_object;
}

static int SConnect_GetSModeForVariant( VARTYPE vartype )
{
	int nSType = S_MODE_NULL;
	switch( vartype )
	{
		case VT_I2:
		case VT_I4:
			nSType = S_MODE_INT;
		break;

		case VT_R4:
			nSType = S_MODE_REAL;
		break;

		case VT_R8:
		case VT_DATE:
		case VT_CY:
			nSType = S_MODE_DOUBLE;
		break;

		case VT_BSTR:
			nSType = S_MODE_CHAR;
		break;

		case VT_EMPTY:
		case VT_ERROR:
			nSType = S_MODE_CHAR;
		break;

		case VT_BOOL:
			nSType = S_MODE_LGL;
		break;
	}
	return nSType;
}

static s_object * SPL_GenerateFromVARIANT( long rows, long cols, void *pvData, BOOL b2dAsDataFrame )
{
	s_object * ps_object = NULL;
	if ( rows <= 0 || cols <= 0 )
		return ps_object;
	if ( !pvData )
		return ps_object;

	try
	{
		if( !S_evaluator->_eval_open )
			SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);

		if ( cols > 1 )
		{
			CSPlist tmpList(cols);
			CSPobject spObj;

			for ( int i=0; i<cols; i++ )
			{
				int j=0;

				s_object *ps_tmp = NULL;
				VARTYPE vaFirstElementType = VT_EMPTY;
				VARIANT *pVariantArray = ((VARIANT *)pvData)+(i*rows);
				for( j=0; j<rows; j++ )
				{
					VARIANT vaElement = pVariantArray[j];
					vaFirstElementType = vaElement.vt;

					if ( vaFirstElementType == VT_ERROR ||
						  vaFirstElementType == VT_EMPTY )
						continue;

					if ( vaFirstElementType != VT_VARIANT &&
						  (vaFirstElementType & VT_ARRAY) == 0 )
					{
						ps_tmp = SCONNECT_GenerateSObjectFromVariant( &vaElement );
						if ( !SPL_NotThere( ps_tmp ) )
							break;
					}
				}
				if ( !ps_tmp )
					ps_tmp = NEW_CHARACTER(0);

				CSPvector *pVec = (CSPvector *)SCONNECT_GenerateFromSObject( ps_tmp );
				if ( !pVec )
					continue;
				BOOL btimeDate=FALSE;
				BOOL bString = FALSE;

				if ( pVec->Is("timeDate") )
				{
					btimeDate = TRUE;
					pVec->Attach(NEW_NUMERIC(rows));
				}
				else
				{
					pVec->SetLength(0);
					pVec->SetLength( rows );
				}

				for( j=0; j<rows; j++ )
				{
					if(btimeDate)
						na_set(NUMERIC_POINTER(pVec->GetPtr())+j, S_MODE_DOUBLE);

					VARIANT vaElement = pVariantArray[j];

					if ( vaElement.vt == VT_EMPTY ||
						  vaElement.vt == VT_ERROR )
						continue;

					if ( vaElement.vt == VT_BSTR && vaElement.vt != vaFirstElementType )
						continue;

					void *pvElement = NULL;
					if ( !ConvertVariantToVoidPtr( &pvElement, vaElement ) )
						continue;
					if(btimeDate)
					{ // Set as numeric first, convert the whole vector to timeDate at the end.
						double dateValue = *(double *)pvElement;
//						dateValue -= S_DATE_OFFSET;
						NUMERIC_POINTER(pVec->GetPtr())[j] = dateValue;
					}
					else
					{
						int nMode = SConnect_GetSModeForVariant( vaElement.vt );
						if ( nMode == S_MODE_CHAR )
						{
							bString = TRUE;
							char *pszElem = (char*) S_alloc(strlen((char *)pvElement)+1, sizeof(char), S_evaluator);
							strcpy(pszElem, (char *)pvElement);
							((CSPcharacter *)pVec)->SetAtDirect( j, pszElem, FALSE, FALSE );
						}
						else
						{
							SCONNECT_SetElement(pVec->GetPtr(), j, nMode, pvElement);
						}
					}

					if ( pvElement )
						S_ok_free( pvElement, S_evaluator );
				}
				//Convert to timeDate from numeric
				if(btimeDate)
					pVec->Attach(time_from_datenum_automation( pVec->GetPtr() ));

				if ( bString )
					((CSPcharacter *)pVec)->MakeStringsRemovable(FALSE);

				tmpList.SetAtDirect( i, *pVec );

				if ( pVec )
					delete pVec;
			}

			ps_object = tmpList.Detach();

			if (b2dAsDataFrame)
			{
				CSPcall call1("as.data.frame");
				call1.SetArg(ps_object, 1);
				spObj = call1.Eval();
				ps_object = spObj.ClonePermanent();
			}
		}
		else
		{
			s_object *ps_tmp = NULL;
			VARTYPE vaFirstElementType = VT_EMPTY;
			VARIANT *pVariantArray = (VARIANT *)pvData;
			for( int i=0; i<rows; i++ )
			{
				VARIANT vaElement = pVariantArray[i];
				vaFirstElementType = vaElement.vt;

				if ( vaFirstElementType == VT_ERROR ||
					  vaFirstElementType == VT_EMPTY )
					continue;

				if ( vaFirstElementType != VT_VARIANT &&
					  (vaFirstElementType & VT_ARRAY) == 0 )
				{
					ps_tmp = SCONNECT_GenerateSObjectFromVariant( &vaElement );
					if ( !SPL_NotThere( ps_tmp ) )
						break;
				}
			}
			if ( !ps_tmp )
				ps_tmp = NEW_CHARACTER(0);

			CSPvector *pVec = (CSPvector *)SCONNECT_GenerateFromSObject( ps_tmp );
			if ( pVec )
			{
				BOOL btimeDate=FALSE;
				BOOL bString = FALSE;

				if ( pVec->Is("timeDate") )
				{
					btimeDate = TRUE;
					pVec->Attach(NEW_NUMERIC(rows));
				}
				else
				{
					pVec->SetLength(0);
					pVec->SetLength( rows );
				}

				for( int i=0; i<rows; i++ )
				{
					if(btimeDate)
						na_set(NUMERIC_POINTER(pVec->GetPtr())+i, S_MODE_DOUBLE);

					VARIANT vaElement = pVariantArray[i];

					if ( vaElement.vt == VT_EMPTY ||
						  vaElement.vt == VT_ERROR )
						continue;

					if ( vaElement.vt == VT_BSTR && vaElement.vt != vaFirstElementType )
						continue;

					void *pvElement = NULL;
					if ( !ConvertVariantToVoidPtr( &pvElement, vaElement ) )
						continue;
					if(btimeDate)
					{ // Set as numeric first, convert the whole vector to timeDate at the end.
						double dateValue = *(double *)pvElement;
//						dateValue -= S_DATE_OFFSET;
						NUMERIC_POINTER(pVec->GetPtr())[i] = dateValue;
					}
					else
					{
						int nMode = SConnect_GetSModeForVariant( vaElement.vt );
						if ( nMode == S_MODE_CHAR )
						{
							bString = TRUE;
							char *pszElem = (char*) S_alloc(strlen((char *)pvElement)+1, sizeof(char), S_evaluator);
							strcpy(pszElem, (char *)pvElement);
							((CSPcharacter *)pVec)->SetAtDirect( i, pszElem, FALSE, FALSE );
						}
						else
						{
							SCONNECT_SetElement(pVec->GetPtr(), i, nMode, pvElement);
						}
					}

					if ( pvElement )
						S_ok_free( pvElement, S_evaluator );
				}
				//Convert to timeDate from numeric
				if(btimeDate)
				{
					ps_object = time_from_datenum_automation( pVec->GetPtr() );
				}
				else
				{
					if ( bString )
						((CSPcharacter *)pVec)->MakeStringsRemovable(FALSE);
					ps_object = pVec->Detach();
				}
				delete pVec;
			}
		}
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	return ps_object;
}

s_object * SCONNECT_GenerateSObjectFromVariant( void *pvVariant, BOOL b2dAsDataFrame )
{
	s_object *ps_object = NULL;

	BOOL bIsArray = FALSE;
	BOOL bAllocatedData = FALSE;
	HRESULT hr = S_OK;

	SAFEARRAY *pSafeArray = NULL;
	UINT dimensions = 1;
	long lBound1 = 0, uBound1 = 0;
	long lBound2 = 0, uBound2 = 0;
	long rows = 0, cols = 0;
	void HUGEP *pvData = NULL;

	LPVARIANT lpVariant = (LPVARIANT)pvVariant;
	if ( !lpVariant )
		return ps_object;

	try
	{
		if( !S_evaluator->_eval_open )
			SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);
	}
	catch(CSPexception& except)
	{
		except.Print();
		return ps_object;
	}

	VARTYPE inputVariantType = lpVariant->vt;
	if ( !IsValidVariantType( inputVariantType ) )
		return ps_object;

	LPVARIANT lpActualVariant = ConvertByRefVariantToVariant( *lpVariant );
	if ( lpActualVariant )
		inputVariantType = lpActualVariant->vt;
	if ( !IsValidVariantType( inputVariantType ) )
		return ps_object;

	VARTYPE actualDataType = GetActualDataTypeFromVariant( *lpActualVariant );
	if ( !IsValidVariantType( actualDataType ) )
		return ps_object;

	if ( inputVariantType & VT_ARRAY )
	{
		VARTYPE arrayDataType = inputVariantType & ~VT_ARRAY;
		if ( !IsValidVariantType( arrayDataType ) )
			return ps_object;

		if ( arrayDataType & VT_BYREF )
			inputVariantType = arrayDataType & ~VT_BYREF;
		else	
			inputVariantType = arrayDataType;

		bIsArray = TRUE;
	}

	if ( bIsArray )
	{
		pSafeArray = GetSafeArrayFromVariant( lpActualVariant );
		if ( !pSafeArray )
			return ps_object;

		dimensions = SafeArrayGetDim( pSafeArray );
		if ( dimensions > 2 || dimensions < 1 )
			return ps_object;

		hr = SafeArrayGetLBound(pSafeArray, 1, &lBound1);
		if ( hr != S_OK )
			return ps_object;
		hr = SafeArrayGetUBound(pSafeArray, 1, &uBound1);
		if ( hr != S_OK )
			return ps_object;
		if ( dimensions == 2 )
		{
			hr = SafeArrayGetLBound(pSafeArray, 2, &lBound2);
			if ( hr != S_OK )
				return ps_object;
			hr = SafeArrayGetUBound(pSafeArray, 2, &uBound2);
			if ( hr != S_OK )
				return ps_object;
		}

		rows = uBound1 - lBound1 + 1;
		cols = uBound2 - lBound2 + 1;
		if ( rows <= 0 || cols <= 0 )
			return ps_object;

		hr = SafeArrayAccessData (pSafeArray, &pvData);
		if ( hr != S_OK || !pvData )
			return ps_object;
	}
	else
	{
		rows = 1;
		cols = 1;

		if ( inputVariantType != VT_VARIANT )
		{
			if ( !ConvertVariantToVoidPtr( &pvData, *lpActualVariant ) )
				return ps_object;
			if ( !pvData )
				return ps_object;
			bAllocatedData = TRUE;

			if(inputVariantType == VT_CY)
			{
				inputVariantType = VT_R8;
			}
		}
	}

	try
	{
		switch( inputVariantType )
		{
			case VT_I2:
			{
				ps_object = SPL_GenerateFromSHORT( rows, cols, pvData, b2dAsDataFrame );
			}
			break;

			case VT_I4:
			{
				ps_object = SPL_GenerateFromVptr( S_MODE_INT, rows, cols, GetVariantDataSize(inputVariantType), pvData, b2dAsDataFrame );
			}
			break;

			case VT_R4:
			{
				ps_object = SPL_GenerateFromFLOAT( rows, cols, pvData, b2dAsDataFrame );
			}
			break;

			case VT_R8:
			{
				ps_object = SPL_GenerateFromVptr( S_MODE_DOUBLE, rows, cols, GetVariantDataSize(inputVariantType), pvData, b2dAsDataFrame );
			}
			break;

			case VT_DATE:
			{
				ps_object = SPL_GenerateFromDATE( rows, cols, pvData, b2dAsDataFrame );
			}
			break;

			case VT_CY:
			{
				ps_object = SPL_GenerateFromCURRENCY( rows, cols, pvData, b2dAsDataFrame );
			}
			break;

			case VT_BSTR:
			{
				if ( bAllocatedData )
					ps_object = SPL_GenerateFromVptr( S_MODE_CHAR, rows, cols, sizeof(char *), &pvData, b2dAsDataFrame );
				else
					ps_object = SPL_GenerateFromBSTR( rows, cols, pvData, b2dAsDataFrame );
			}
			break;

			case VT_DISPATCH:
			{
				ps_object = SPL_GenerateFromDISPATCH( rows, cols, pvData, b2dAsDataFrame );
			}
			break;

			case VT_EMPTY:
			case VT_ERROR:
				ps_object = SPL_GenerateFromBSTR( rows, cols, NULL, b2dAsDataFrame );
			break;

			case VT_BOOL:
			{
				ps_object = SPL_GenerateFromVptr( S_MODE_LGL, rows, cols, GetVariantDataSize(inputVariantType), pvData, b2dAsDataFrame );
			}
			break;

			case VT_VARIANT:
			{
				ps_object = SPL_GenerateFromVARIANT( rows, cols, pvData, b2dAsDataFrame );
			}
			break;

			case VT_UNKNOWN:
			break;
		}
	}
	catch(...)
	{
		ps_object = NULL;
	}

	if ( bIsArray )
	{
		if ( pSafeArray && !bAllocatedData )
		{
			// Release the ref on the safearray
			hr = SafeArrayUnaccessData (pSafeArray);
		}
	}

	if ( bAllocatedData )
	{
		S_ok_free( pvData, S_evaluator );
		pvData = NULL;
	}

	return ps_object;
}

#endif // WIN32
