/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	aparray.h: interface for the CSParray class.
*/

#if !defined(__SCONNECT_ARRAY_H_INCLUDED__)
#define __SCONNECT_ARRAY_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "spstruct.h"
#include "spproxy.h"
#include "spnum.h"
#include "spint.h"
#include "splist.h"
class SCONNECT_LIB_EXTERN CSParray : public CSPstructure  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:
	//Default constructor
	CSParray();
	//Copy constructor: copy appropriate data members
	CSParray(const CSParray& sObject);
	//Construct from object of a base class
	CSParray(const CSPobject& sObject);
	//Construct from a valid S-expression
	explicit CSParray(const char* pszExpression);
	//Construct frmo an S object pointer  
	explicit CSParray(s_object* ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Assign from the same class
	CSParray& operator=(const CSParray& sObject);
	//Assign from the base class
	CSParray& operator=(const CSPobject& sObject);
	//Assign from an S object
	CSParray& operator=(s_object* ps_object);
	//The destructor
	virtual ~CSParray();

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:
 	//Proxy to assist indexing operator for lvalue/rvalue, type conversions and ref count.
	class SCONNECT_LIB_EXTERN CProxy : public CSPproxy
	{
	public:
		CProxy(){};
		CProxy(CSParray* psArray, long lZeroBasedIndex);
		CProxy(const CProxy& rhs); //copy constructor
		CProxy(s_object* ps_object, long lZeroBasedIndex):CSPproxy(ps_object, lZeroBasedIndex){};
		virtual ~CProxy(){};
		//Set the element to the value void* pRhs which is casted as lMode
		virtual void SetElementAs( void* pRhs, long lMode, BOOL bCopyIfNeeded = TRUE);

		// Assignment operators
		CProxy& operator=(int nRhs);
		CProxy& operator=(long lRhs);
		CProxy& operator=(float fRhs);
		CProxy& operator=(double dRhs);
		CProxy& operator=(const CSPproxy& proxyRhs);
	};
	//...continue CSParray

	//Subscripting for both lhs and rhs of "=", Fortran style and based-one-indexing
	//Limitation: max dimension: 5
	CProxy operator () (long lIndex1, long lIndex2=1, long lIndex3=1, long lIndex4=1, long lIndex5=1);
 //Return TRUE if the object is a valid 'array' class
	virtual BOOL IsValid(void) const;
	//Return pointer to the .Dim slot
	CSPinteger GetDim(BOOL bValidate=TRUE) const;
	//Return pointer to the .Dimnames slot
	CSPlist GetDimnames(BOOL bValidate=TRUE) const;
	//Set data to mode specified by lSMode
	virtual void SetDataMode(int lSMode);
	virtual int GetDataMode(BOOL bValidate=TRUE) const;
	//Attach an S object and coerce to appropriate class that override this method
	virtual void Attach(s_object *ps_object, BOOL bTryToFreeOnDetach=FALSE);
	friend class CProxy;
//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
protected:
	//Intends to be use by CSPproxy to match with CSParray::GetData()
	s_object* GetVector(long lIndex=1) const
	{
		return GetData(FALSE);
	} 
		
};

#define SPL_DOT_DIM (char*)Dim_name->text
#define SPL_DOT_DIMNAMES (char*)Dimnames_name->text

#endif // !defined(__SCONNECT_ARRAY_H_INCLUDED__)
