/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
 
	spbrace.cxx: implementation of the CSPbrace class wrapping S-PLUS object of class "{".
*/

#include "S_y_tab.h"
#include "spbrace.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//Default constructor
CSPbrace::CSPbrace()
: CSPlanguage()
{
}
//Copy constructor 
CSPbrace::CSPbrace(const CSPbrace& sObject)
: CSPlanguage()
{
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
}
//Construct from a base class object
CSPbrace::CSPbrace(const CSPobject& sObject)
: CSPlanguage()
{	
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
}
//Construct from a valid S-expression
CSPbrace::CSPbrace(const char* pszExpression)
: CSPlanguage()
{
	CSPevaluator sEvaluator;
	s_object* ps_value = sEvaluator.Eval(pszExpression);
	Attach(sEvaluator.CloneIfNeeded(ps_value), TRUE);

}
//Construct from a valid S object
CSPbrace::CSPbrace(s_object* ps_object, BOOL bTryToFreeOnDetach)
: CSPlanguage()
{
	Attach(ps_object, bTryToFreeOnDetach);
}
//Assigment from the same class
CSPbrace& CSPbrace::operator=(const CSPbrace& sObject)
{
	Attach(&sObject, TRUE);
	return *this;
}
//Assigment from the base class
CSPbrace& CSPbrace::operator=(const CSPobject& sObject)
{
	Attach(&sObject, TRUE);
	return *this;
}
//Assigment from the S object
CSPbrace& CSPbrace::operator=(s_object* ps_object)
{
	Attach(ps_object, FALSE);
	return *this;
}
//The destructor
CSPbrace::~CSPbrace()
{
}


//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////

//Return TRUE if the object is a valid class
BOOL CSPbrace::IsValid(void) const
{
	if(CSPobject::IsValid()) 
		return (GetMode(FALSE) == S_MODE_LBRACE);
	return FALSE;
}

//Validate the evaluator
void CSPbrace::Validate(void) const
{
	if(!IsValid())
		SCONNECT_ThrowException("Invalid '{' object\n");
}

void CSPbrace::Attach(s_object *ps_object, BOOL bTryToFreeOnDetach)
{
	BaseCoerceAttach(ps_object, MAKE_CLASS("brace"), bTryToFreeOnDetach);
}

//Eval in current eval frame
CSPobject CSPbrace::Eval(void) const             
{
	if(!IsValid())
		throw SCONNECT_INVALID_CLASS;

	CSPobject sValue;
	try
	{ 
		CSPevaluator sEvaluator; //If frame 1 does not exist, open it.
		sValue.Attach(sEvaluator.Eval(&(*this)), TRUE);
	}
	catch(...)
	{
		sValue.Attach(NULL);
	}

	if(!sValue.IsValid())
		throw SCONNECT_EVALUATION_FAILURE;

	return sValue;
}

