# Standard Perl modules:
use Getopt::Long ;

# Splus Perl modules:
use Splus::Utils ;      # in SHOME/library/pkgutils/share/perl
use Splus::SplusUtils ; # in SHOME/share/perl
use Splus::Vars ;
use Splus::src2bin ;
use Splus::packup ;
use File::Basename ;

@knownoptions = ("binary", "help|h") ;
GetOptions(@knownoptions) || usage() ;

if($opt_help) {
    usage() ;
    exit() ;
}

my $pkgdir = $ARGV[0] ;
if("$pkgdir" eq "") {
    usage() ;
    die "Missing pkgdir argument" ;
}
if(! -d $pkgdir) {
    die "$pkgdir does not appear to be a directory" ;
}

my $ostype = ${Splus::Vars::OSTYPE} ; # returns "windows" or "unix"

# First copy to tmp directory for building.
my $blddir = Splus_tempfile("Sbld") ;
mkdir $blddir or die "Cannot make temporary build directory $blddir ($!)" ;
Splus::SplusUtils::copy_source_package($pkgdir, $blddir, "native") ;

my $pkgname = basename($pkgdir) ;
my $dcf = Splus::Dcf->new($blddir . "/" . $pkgname . "/DESCRIPTION") ;

die "Illegal version string, \"" , $dcf->{"Version"} , "\", in " , $pkgname , "/DESCRIPTION", " (expect integers separated by periods or hyphens)\n" if !($dcf->{"Version"} =~ /^([[:digit:]]+[.-]){1,}[[:digit:]]+$/) ;

if ( $dcf->{"Package"} ne $pkgname ) {
    rename( $blddir . "/" . $pkgname, $blddir . "/" . $dcf->{"Package"} ) or
        die "Cannot rename package directory to its internal name ($!)\n" ;
    $pkgname = $dcf->{"Package"} ;

}
print "pkgdir=$pkgdir, pkgname=$pkgname\n";
# The installers don't yet have a clean-but-dont-make option yet
File::Path::rmtree("$blddir/$pkgname/.Data") if -d "$blddir/$pkgname/.Data" ;
foreach my $shlib ("S.so", "S.dll") {
   unlink("$blddir/$pkgname/$shlib") if -e "$blddir/$pkgname/$shlib" ;
}

# If binary option set on command line, call src2bin 
if($opt_binary) {
    my @arglist = ("--parent-dir", "$blddir",
                   "--clean-first",
                   "--name", $pkgname,
                   "--clean-after",
                   "--update-description") ; 
    my $sb = Splus::src2bin->new(@arglist) ;
    $sb->make() ;
}

my @arglist = ("--parent", "$blddir", "--name", $pkgname) ;
if ($opt_binary) {
    push @arglist, "--type",  "binary" ;
} else {
    push @arglist, "--type",  "source" ;
}
my $pu = Splus::packup->new(@arglist) ;
my $packaged_package = $pu->make() ;
File::Path::rmtree("$blddir") ;
print $packaged_package, "\n" ;

sub usage() {
    print "Usage: Splus CMD build [options] pkgdir\n" ;
    print "\nBuild Spotfire S+ packages from package source\n" ;
    print "\nOptions:\n" ;
    print "-h,--help     # print this help message\n" ;
    print "--binary      # build a pre-compiled binary package\n" ;
    @_ && die join(", ", @_) ;
    exit() ;
}
