#!/usr/bin/python
# vim:tabstop=2:shiftwidth=2:expandtab

import os
import sys
import termios
import pwd

from subprocess import *
from optparse import OptionParser

debug = "yes"

class ArgvWrapper:
    
  def __init__(self):
    self.SmbShare      = ""
    self.SmbOptions    = ""
    self.SmbUser       = ""
    self.MountPoint    = ""
    self.DfsScan       = False
    self.DfsCreateDirs = False
    self.DfsExclude    = []

  def getSmbShare(self):
    return self.SmbShare
      
  def getSmbOptions(self):
    return self.SmbOptions

  def getSmbUser(self):
    return self.SmbUser

  def getMountPoint(self):
    return self.MountPoint

  def getDfsScan(self):
    return self.DfsScan

  def getDfsCreateDirs(self):
    return self.DfsCreateDirs

  def getDfsExclude(self):
    return self.DfsExclude

  def isExcluded(self, directory):
    for d in self.DfsExclude:
      if d == directory:
        return True
    return False
      

  def parse(self):
    if debug == "yes":
      f = open('/tmp/mount.log', 'a')
      f.write('%s\n' % sys.argv)
      f.close()
    parser = OptionParser("usage: %prog [-o options] share mountpoint")
    # get smb options
    parser.add_option("-o", action="store", type="string",
      dest="smbopt", help="smb mount options")
    (options, args) = parser.parse_args()
    # check for dfs option and get excluded dfs shares
    smbopt_list = []
    if options.smbopt != None:
      for e in options.smbopt.split(','):
        el = e.lower()
        if el == 'dfs':
            self.DfsScan = True
        elif el == 'dfscreate':
            self.DfsCreateDirs = True
        elif el.startswith("dfsexclude="):
            self.DfsExclude = el.split('=')[1].split(':')
        elif el.startswith("user="):
            self.SmbUser = el.split('=')[1]
            smbopt_list.append(el)
        else:
            smbopt_list.append(el)
      self.SmbOptions = ','.join(smbopt_list)
    # parse remaining args
    if len(args) != 2:
      parser.error("incorrect number of arguments")
    for a in args:
      s = a.replace("\\", "/")
      if s.startswith("//"):
        self.SmbShare = s
      else:
        self.MountPoint = s           

        
class SmbWrapper:

  CmdMount  = 'mount -t cifs '
  CmdUmount = 'umount -t cifs '
  DfsMount  = '/var/run/cifsdfs'

  def __init__(self):
    # get mount points
    self.Mounts = {}
    f = open("/proc/mounts", "r")
    for line in f:
      mount = line.strip().split(" ")
      self.Mounts[mount[1]] = mount
    f.close()

  def isMountPoint(self, directory):
    return self.Mounts.has_key(directory)

  def getpass(self, prompt = 'Password: '):
    fd     = sys.stdin.fileno()
    old    = termios.tcgetattr(fd)
    new    = termios.tcgetattr(fd)
    new[3] = new[3] & ~termios.ECHO          # lflags
    try:
      termios.tcsetattr(fd, termios.TCSADRAIN, new)
      passwd = raw_input(prompt)
    finally:
      termios.tcsetattr(fd, termios.TCSADRAIN, old)
    return passwd


  def mount(self, share, mpoint, options, password):
    os.putenv("PASSWD_FD", "0")
    cmd = "%s %s %s -o %s" % (SmbWrapper.CmdMount, share, mpoint, options)
    if debug == "yes":
      f = open('/tmp/mount.log', 'a')
      f.write('%s\n' % cmd)
      f.close()
    p = Popen(cmd, shell=True, stdin=PIPE, stdout=PIPE, stderr=PIPE, close_fds=True)
    p.stdin.write(password)
    p.stdin.close()
    sys.stdout.write(p.stdout.read())
    p.stdin.close()
    sys.stderr.write(p.stderr.read())
    p.stderr.close()
    
  def umount(self, mpoint):
    os.putenv("PASSWD_FD", "0")
    cmd = "%s %s " % (SmbWrapper.CmdUmount,  mpoint)
    p = Popen(cmd, shell=True, stdin=PIPE, stdout=PIPE, stderr=PIPE, close_fds=True)
    p.stdin.close()
    sys.stdout.write(p.stdout.read())
    p.stdout.close()
    sys.stderr.write(p.stderr.read())
    p.stderr.close()

 
def main():
  argvWrapper = ArgvWrapper()
  argvWrapper.parse()
  
  smbWrapper = SmbWrapper()

  # get password
  password = ""
  if os.getenv("PASSWD_FD") != None:
    password = sys.stdin.read()
  else:
    password = smbWrapper.getpass("Cifs password: ")

  pw = pwd.getpwnam(argvWrapper.getSmbUser())
  if pw.pw_uid < 4000:
    sys.exit(0)
         
  if argvWrapper.getDfsScan():
    # mount msdfs links
    if not os.path.isdir(SmbWrapper.DfsMount):
      os.mkdir(SmbWrapper.DfsMount, 0700)
    dfspoint = os.path.join(SmbWrapper.DfsMount, argvWrapper.getSmbUser())
    if not smbWrapper.isMountPoint(dfspoint):
      # mount dfs share if not already mounted
      if not os.path.isdir(dfspoint):
        os.mkdir(dfspoint, 0700)
      smbWrapper.mount(
        argvWrapper.getSmbShare(),
        dfspoint,
        argvWrapper.getSmbOptions(),
        password)
    # scan for msdfs links
    dfs_list = []
    for d in os.listdir(dfspoint):
      d2 = os.path.join(dfspoint, d)
      if os.path.islink(d2):
        # check if execluded
        if argvWrapper.isExcluded(d):
          continue
        # get link destination
        dest = os.readlink(d2).lower()
        if dest.startswith("msdfs:"):
          # setup share and mount point
          share  = "//" + dest.split("msdfs:")[1].replace("\\", "/")
          mpoint = os.path.join(argvWrapper.getMountPoint(), d)
          # create mount point
          if argvWrapper.getDfsCreateDirs() and not os.path.isdir(mpoint):
            os.mkdir(mpoint, 0700)
          if not smbWrapper.isMountPoint(mpoint):
            # mount the share if not already mounted
            smbWrapper.mount(share, mpoint,
              argvWrapper.getSmbOptions(), password)
      
  else:
    # ordinary cifs mount
    if not smbWrapper.isMountPoint(argvWrapper.getMountPoint()):
      smbWrapper.mount(
        argvWrapper.getSmbShare(),
        argvWrapper.getMountPoint(),
        argvWrapper.getSmbOptions(), password)

  # clear password ?
  del(password)


if __name__ == "__main__":
  main()
