# Copyright 2025 GNOME Foundation, Inc.
# SPDX-License-Identifier: CC-BY-SA-3.0

System integration of malcontent
===

This document describes what is needed to integrate the various parts of
malcontent into a system beyond what is done by running `meson install`.

Packagers should read this document.

Web filtering
---

In order to enable web filtering:
 1. Enable `malcontent-webd.service`, `malcontent-webd-update.service` and
    `malcontent-webd-update.timer` systemd units
 2. Add `malcontent` to the `hosts:` line of `/etc/nsswitch.conf` so it’s used
    fairly early on in the name resolution process. `meson install` cannot do
    this.

An example of the relevant `/etc/nsswitch.conf` line with `malcontent` enabled:
```
hosts:      files myhostname malcontent mdns4_minimal [NOTFOUND=return] resolve [!UNAVAIL=return] dns
```
