#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Jenny LeClue - Detectivú
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240825.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='jenny-leclue-detectivu'
GAME_NAME='Jenny LeClue - Detectivú'

ARCHIVE_BASE_1_NAME='jenny_leclue_detectivu_2_2_1_47129.sh'
ARCHIVE_BASE_1_MD5='bb03cb3d7c6abf4be7060ed4cf126b2e'
ARCHIVE_BASE_1_SIZE='2100000'
ARCHIVE_BASE_1_VERSION='2.2.1-gog47129'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/jenny_leclue_detectivu'

ARCHIVE_BASE_0_NAME='jenny_leclue_detectivu_2_1_1_42681.sh'
ARCHIVE_BASE_0_MD5='21c681f13664bbb1259f4807cc388742'
ARCHIVE_BASE_0_SIZE='1900000'
ARCHIVE_BASE_0_VERSION='2.1.1-gog42681'

UNITY3D_NAME='Jenny LeClue - Detectivu'

CONTENT_PATH_DEFAULT='data/noarch/game'
## TODO: The shipped plugins to include should be listed using UNITY3D_PLUGINS
CONTENT_GAME0_BIN64_FILES="
${UNITY3D_NAME}/Plugins/x86_64"
CONTENT_GAME0_BIN32_FILES="
${UNITY3D_NAME}/Plugins/x86"

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
## TODO: This dependencies list is probably not complete
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libgdk_pixbuf-2.0.so.0
libgtk-x11-2.0.so.0
libgobject-2.0.so.0
libglib-2.0.so.0
libstdc++.so.6
libz.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
