/**
 * Copyright (c) 2014-2026 Governikus GmbH & Co. KG, Germany
 */

#pragma once

#include <QList>
#include <QLocale>
#include <QSharedPointer>
#include <QTranslator>


class test_LanguageLoader;
class test_ProviderParser;
class test_ProviderConfigurationParser;


namespace governikus
{

class LanguageLoader
{
	Q_DISABLE_COPY(LanguageLoader)
	friend class ::test_LanguageLoader;
	friend class ::test_ProviderConfigurationParser;

	private:
		static const QLocale::Language mFallbackLanguage;
		static QLocale mDefaultLanguage;

		QString mPath;
		QList<QSharedPointer<QTranslator>> mTranslatorList;
		const QStringList mComponentList;
		QLocale mUsedLocale;

		bool loadTranslationFiles(const QLocale& pLocale);
		QSharedPointer<QTranslator> createTranslator(const QLocale& pLocale, const QString& pComponent);
		[[nodiscard]] static const QLocale& getDefaultLanguage();

	protected:
		LanguageLoader();
		~LanguageLoader() = default;

	public:
		static LanguageLoader& getInstance();
		static QString getLocaleCode(const QLocale& pLocale = getInstance().getUsedLocale());

#ifndef QT_NO_DEBUG
		[[nodiscard]] const QString& getPath() const;
		void setPath(const QString& pPath);
#endif

		void load(const QLocale& pLocale = getDefaultLanguage());
		void unload();
		[[nodiscard]] bool isLoaded() const;
		[[nodiscard]] const QLocale& getUsedLocale() const;
		[[nodiscard]] QLocale::Language getFallbackLanguage() const;
		[[nodiscard]] QList<QLocale> getAvailableLocales() const;
};

} // namespace governikus
