# Contributing to DocumentDB

Thank you for your interest in contributing to DocumentDB. There are several ways through which contributions to the project can be made and you can get involved.

## Asking Questions

[Join us on Discord](https://discord.gg/vH7bYu524D) to engage directly with our team and the community with any questions you may have. Our channel is not only a place for immediate assistance but also a hub for discussing project updates, upcoming features, and technical challenges. We host regular meetings where TSC members and contributors can interact directly to ask questions, share feedback, and discuss their ideas in real time.

## Reporting Issues

Before a new issue is created for a bug or feature request, please check the list of open issues to avoid multiple issues being created for the same bug or feature. If one already exists, add a reaction and relevant comments for additional clarity if needed.

## How to Contribute

We encourage community members to participate by reporting issues, suggesting new features, or contributing code.

### 1. General Contributions

The more descriptive the issue is and the more information that can be provided, the more helpful it will be to the community and the contributors to pick up the issue.

For each issue created, please include: 

- A brief description of the suggestion or issue.
- Relevant details such as the operating system you were using, if applicable.
- Clear, step-by-step instructions or context that describe how the issue occurred or how the feature would function.
- The expected outcome versus the actual result or behavior observed, if relevant.

### Code Contributions

For those looking to contribute code, whether for bug fixes or new features, please ensure your issues and pull requests include the following:

- A code snippet that reliably reproduces the issue or demonstrates the new feature.
- An accessible repository link that can be cloned, built, and run, providing a complete environment for testing and verifying the issue or feature.
- Clear documentation or comments in the code explaining the changes made and their purpose.

## Pull Requests

We want to ensure all contributions made by the developer community are correctly licensed. To achieve this, DocumentDB uses a Developer Certificate of Origin (DCO). The DCO is a declaration attached to each commit to the project. A message that simply adds a Signed-off-by statement to every commit to DocumentDB is all that is needed and this confirms that the committer agrees to the DCO, which can be located at https://developercertificate.org/.

DocumentDB requires every contribution to be signed with a DCO through a known identity. Anonymous names or pseudonyms cannot be used. An example of a DCO signed commit message is:

```bash
Commit message

Signed-off-by: John Doe <john.doe@email.com>
```

Git includes a `-s` command line option to append this line automatically to your commit message (provided you have configured your `user.name` and `user.email` in your git configuration):

```bash
git commit -s -m 'Commit message'
```

Commits of any form require a DCO, including revert commits.

## Technical Steering Committee and Maintainers

DocumentDB is governed by the Technical Steering Committee, where all decisions are conducted in the open, documented, and voted upon. All code that is checked in is managed by the Maintainers. The list of TSC members and the project's maintainers are listed in the [MAINTAINERS.md](./MAINTAINERS.md) file. 

## Discussion Etiquette

To provide all members of the community with a safe space for contributions and discussions, we request that comments always be courteous and respectful of others.
