% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-tufteboxplot.R
\docType{data}
\name{geom_tufteboxplot}
\alias{geom_tufteboxplot}
\alias{GeomTufteboxplot}
\title{Tufte's Box Plot}
\usage{
geom_tufteboxplot(
  mapping = NULL,
  data = NULL,
  stat = "fivenumber",
  position = "dodge",
  outlier.colour = "black",
  outlier.shape = 19,
  outlier.size = 1.5,
  outlier.stroke = 0.5,
  voffset = 0.01,
  hoffset = 0.005,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  median.type = "point",
  whisker.type = "line",
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string. The default (\code{stat = 'fivenumber'}) calls
\code{\link{stat_fivenumber}} and produces whiskers that extend
from the interquartile range to the extremes of the data; specifying
\code{\link[ggplot2]{stat_boxplot}} will produce a more traditional boxplot
with whiskers extending to the most extreme points that are < 1.5 IQR
away from the hinges (i.e., the first and third quartiles).}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{outlier.colour}{colour for outlying points}

\item{outlier.shape}{shape of outlying points}

\item{outlier.size}{size of outlying points}

\item{outlier.stroke}{stroke for outlying points}

\item{voffset}{controls the size of the gap in the line representing the
median when \code{median.type = 'line'}. This is a fraction of the range
of \code{y}.}

\item{hoffset}{controls how much the interquartile line is offset from the
whiskers when \code{median.type = 'line'}. This is a fraction of the
range of \code{x}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{median.type}{If \code{'point'}, then the median is represented by a
point, and the interquartile range by a gap in the line. If
\code{median.type='line'}, then the interquartile range is represented by
a line, possibly offset, and the median by a gap in the line.}

\item{whisker.type}{If \code{'line'}, then whiskers are represented by lines.
If \code{'point'}, then whiskers are represented by points at
\code{ymin} and \code{ymax}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}
}
\description{
Edward Tufte's revisions of the box plot as described in
\emph{The Visual Display of Quantitative Information}.
This functions provides several box plot variants:
\itemize{
\item{A point indicating the median, a gap indicating the
  interquartile range, and lines for whiskers.}
\item{An offset line indicating the interquartile range
      and a gap indicating the median.}
\item{A line indicating the interquartile range,
      a gap indicating the median, and points indicating
      the minimum and maximum values}
\item{A  wide line indicating the interquartile range,
      a gap indicating the median, and lines indicating the minimum and
      maximum.}
}
}
\section{Aesthetics}{

\itemize{
\item x [required]
\item y [required]
\item colour
\item size
\item linetype
\item shape
\item fill
\item alpha
}
}

\examples{
library("ggplot2")

p <- ggplot(mtcars, aes(factor(cyl), mpg))
# with a point for the median and lines for whiskers
p + geom_tufteboxplot()
# with a line for the interquartile range and points for whiskers
p + geom_tufteboxplot(median.type = "line", whisker.type = "point", hoffset = 0)
# with a wide line for the interquartile range and lines for whiskers
p + geom_tufteboxplot(median.type = "line", hoffset = 0, width = 3)
# with an offset line for the interquartile range and lines for whiskers
p + geom_tufteboxplot(median.type = "line")
# combined with theme_tufte
p + geom_tufteboxplot() + theme_tufte() + theme(axis.ticks.x = element_blank())
# traditional boxplot with whiskers only out to 1.5 IQR, outlier points
p + geom_tufteboxplot(stat = "boxplot", outlier.shape = 5)
}
\references{
Tufte, Edward R. (2001) The Visual Display of
Quantitative Information, Chapter 6.

McGill, R., Tukey, J. W. and Larsen, W. A. (1978) Variations of
box plots. The American Statistician 32, 12-16.
}
\seealso{
\code{\link[ggplot2]{geom_boxplot}()}

Other geom tufte: 
\code{\link{geom_rangeframe}()}
}
\concept{geom tufte}
\keyword{datasets}
