% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R
\name{remove_RLum}
\alias{remove_RLum}
\alias{remove_RLum,list-method}
\alias{remove_RLum,RLum.Analysis-method}
\title{Strips records from RLum-class objects}
\usage{
remove_RLum(object, ...)

\S4method{remove_RLum}{list}(object, ...)

\S4method{remove_RLum}{RLum.Analysis}(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
object with records to be removed.}

\item{...}{parameters to be passed to \link{get_RLum}. The arguments \code{get.index} and
\code{drop} are preset and have no effect when provided}
}
\value{
An object of the same type as the input provided with records removed; it
can result in an empty object.
}
\description{
Remove records from an RLum-class object in a convenient way using
\link{get_RLum} for the selection.
}
\section{Functions}{
\itemize{
\item \code{remove_RLum(list)}: Returns a list of \linkS4class{RLum} objects where the selected records are stripped

\item \code{remove_RLum(RLum.Analysis)}: Method to remove records from an \linkS4class{RLum.Analysis} object.

}}
\section{Function version}{
 0.1.0
}

\examples{
## load example data
data(ExampleData.XSYG, envir = environment())
sar <- OSL.SARMeasurement$Sequence.Object[1:9]

## strop only OSL curves
sar <- remove_RLum(sar, recordType = "OSL")
sar

}
\seealso{
\linkS4class{RLum.Analysis}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. remove_RLum(): Strips records from RLum-class objects. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
